/*
 * Decompiled with CFR 0.152.
 */
package io.buildlogic.truststore.maven.plugin.truststore;

import io.buildlogic.truststore.maven.plugin.bc.BouncyCastleKeyStoreLoader;
import io.buildlogic.truststore.maven.plugin.certificate.CertificateInspector;
import io.buildlogic.truststore.maven.plugin.keystore.KeyStoreFactory;
import io.buildlogic.truststore.maven.plugin.mojo.CustomScryptConfig;
import io.buildlogic.truststore.maven.plugin.truststore.KeyStoreLoader;
import io.buildlogic.truststore.maven.plugin.truststore.TruststoreFormat;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

public class TruststoreWriter {
    private final Log log;
    private final TruststoreFormat format;
    private final String file;
    private final String password;
    private CustomScryptConfig scryptConfig;

    public void write(List<X509Certificate> certs) {
        if (certs.isEmpty()) {
            this.log.warn((CharSequence)"Truststore not generated: no certificates to store");
            return;
        }
        Set<X509Certificate> deduplicatedCerts = this.deduplicateCerts(certs);
        KeyStore keyStore = this.populateKeyStore(deduplicatedCerts);
        this.saveKeyStore(keyStore);
    }

    private Set<X509Certificate> deduplicateCerts(List<X509Certificate> certs) {
        return new HashSet<X509Certificate>(certs);
    }

    private KeyStore populateKeyStore(Set<X509Certificate> certs) {
        KeyStore keyStore;
        try {
            keyStore = KeyStoreFactory.createInstance(this.format);
            keyStore = this.loadKeyStore(keyStore);
            for (X509Certificate cert : certs) {
                CertificateInspector certInspector = new CertificateInspector(this.log, cert);
                this.logCertDetails(certInspector);
                String issuer = certInspector.getIssuer();
                String serialNumber = certInspector.getSerialNumber();
                String alias = String.format("%s - %s", issuer, serialNumber);
                keyStore.setCertificateEntry(alias, cert);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            String cause = e.getMessage();
            String errorMessage = String.format("Error building truststore: %s", cause);
            throw new RuntimeException(errorMessage, e);
        }
        return keyStore;
    }

    private KeyStore loadKeyStore(KeyStore keyStore) throws CertificateException, IOException, NoSuchAlgorithmException {
        if (keyStore.getType().equals(TruststoreFormat.BCFKS.toString()) && this.scryptConfig != null) {
            this.log.info((CharSequence)("Generating " + this.format + " truststore with custom Scrypt parameters:"));
            this.log.info((CharSequence)this.scryptConfig.toString());
            return BouncyCastleKeyStoreLoader.load(keyStore, this.scryptConfig);
        }
        this.log.info((CharSequence)("Generating " + this.format + " truststore"));
        return KeyStoreLoader.load(keyStore);
    }

    private void logCertDetails(CertificateInspector certInspector) {
        Optional<String> subjectAltNames = certInspector.getSubjectAlternativeNames();
        this.log.info((CharSequence)("Serial number:     " + certInspector.getSerialNumber()));
        this.log.info((CharSequence)("Subject:           " + certInspector.getSubject()));
        subjectAltNames.ifPresent(s -> this.log.info((CharSequence)("Subject Alt Names: " + s)));
        this.log.info((CharSequence)("Issuer:            " + certInspector.getIssuer()));
        this.log.info((CharSequence)("Valid between:     " + certInspector.getNotValidBefore() + " and " + certInspector.getNotValidAfter() + " (GMT)" + System.lineSeparator()));
    }

    private void saveKeyStore(KeyStore keyStore) {
        try (FileOutputStream outputStream = new FileOutputStream(this.file);){
            keyStore.store(outputStream, this.password.toCharArray());
            this.log.info((CharSequence)("Total of " + keyStore.size() + " certificates saved to: " + this.file));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            String cause = e.getMessage();
            String errorMessage = String.format("Error writing file %s: %s", this.file, cause);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public TruststoreWriter(Log log, TruststoreFormat format, String file, String password) {
        this.log = log;
        this.format = format;
        this.file = file;
        this.password = password;
    }

    public void setScryptConfig(CustomScryptConfig scryptConfig) {
        this.scryptConfig = scryptConfig;
    }
}

