/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.filter;

import io.buji.pac4j.context.ShiroSessionStore;
import io.buji.pac4j.engine.ShiroSecurityLogic;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.http.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;

public class SecurityFilter
implements Filter {
    private SecurityLogic<Object, J2EContext> securityLogic = new ShiroSecurityLogic();
    private Config config;
    private String clients;
    private String authorizers;
    private String matchers;
    private Boolean multiProfile;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CommonHelper.assertNotNull((String)"securityLogic", this.securityLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        SessionStore sessionStore = this.config.getSessionStore();
        J2EContext context = new J2EContext(request, response, (SessionStore)(sessionStore != null ? sessionStore : ShiroSessionStore.INSTANCE));
        this.securityLogic.perform((WebContext)context, this.config, (ctx, parameters) -> {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return null;
        }, (HttpActionAdapter)J2ENopHttpActionAdapter.INSTANCE, this.clients, this.authorizers, this.matchers, this.multiProfile, new Object[0]);
    }

    public void destroy() {
    }

    public SecurityLogic<Object, J2EContext> getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic<Object, J2EContext> securityLogic) {
        this.securityLogic = securityLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }
}

