/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.realm;

import io.buji.pac4j.subject.Pac4jPrincipal;
import io.buji.pac4j.token.Pac4jToken;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.pac4j.core.profile.CommonProfile;

public class Pac4jRealm
extends AuthorizingRealm {
    private String principalNameAttribute;

    public Pac4jRealm() {
        this.setAuthenticationTokenClass(Pac4jToken.class);
    }

    public String getPrincipalNameAttribute() {
        return this.principalNameAttribute;
    }

    public void setPrincipalNameAttribute(String principalNameAttribute) {
        this.principalNameAttribute = principalNameAttribute;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        Pac4jToken token = (Pac4jToken)authenticationToken;
        LinkedHashMap<String, CommonProfile> profiles = token.getProfiles();
        Pac4jPrincipal principal = new Pac4jPrincipal(profiles, this.principalNameAttribute);
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)principal, this.getName());
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)profiles.hashCode());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        HashSet roles = new HashSet();
        HashSet permissions = new HashSet();
        Pac4jPrincipal principal = (Pac4jPrincipal)principals.oneByType(Pac4jPrincipal.class);
        if (principal != null) {
            List<CommonProfile> profiles = principal.getProfiles();
            for (CommonProfile profile : profiles) {
                if (profile == null) continue;
                roles.addAll(profile.getRoles());
                permissions.addAll(profile.getPermissions());
            }
        }
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        simpleAuthorizationInfo.addRoles(roles);
        simpleAuthorizationInfo.addStringPermissions(permissions);
        return simpleAuthorizationInfo;
    }
}

