/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.context;

import java.util.Optional;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.support.DisabledSessionException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSessionStore
implements SessionStore {
    private static Logger LOGGER = LoggerFactory.getLogger(ShiroSessionStore.class);
    public static final ShiroSessionStore INSTANCE = new ShiroSessionStore();

    protected ShiroSessionStore() {
    }

    protected Session getSession(boolean createSession) {
        try {
            Session session = SecurityUtils.getSubject().getSession(createSession);
            LOGGER.debug("createSession: {}, retrieved session: {}", (Object)createSession, (Object)session);
            return session;
        }
        catch (DisabledSessionException e) {
            return null;
        }
    }

    public Optional<String> getSessionId(WebContext context, boolean createSession) {
        Session session = this.getSession(createSession);
        if (session != null) {
            String sessionId = session.getId().toString();
            LOGGER.debug("Get sessionId: {}", (Object)sessionId);
            return Optional.of(sessionId);
        }
        LOGGER.debug("No sessionId");
        return Optional.empty();
    }

    public Optional<Object> get(WebContext context, String key) {
        Session session = this.getSession(false);
        if (session != null) {
            Object value = session.getAttribute((Object)key);
            LOGGER.debug("Get value: {} for key: {}", value, (Object)key);
            return Optional.ofNullable(value);
        }
        LOGGER.debug("Can't get value for key: {}, no session available", (Object)key);
        return Optional.empty();
    }

    public void set(WebContext context, String key, Object value) {
        Session session = this.getSession(true);
        if (session != null) {
            try {
                if (value instanceof Exception) {
                    LOGGER.debug("Set key: {} for value: {}", (Object)key, (Object)value.toString());
                } else {
                    LOGGER.debug("Set key: {} for value: {}", (Object)key, value);
                }
                session.setAttribute((Object)key, value);
            }
            catch (UnavailableSecurityManagerException e) {
                LOGGER.warn("Should happen just once at startup in some specific case of Shiro Spring configuration", (Throwable)e);
            }
        }
    }

    public boolean destroySession(WebContext context) {
        this.getSession(true).stop();
        return true;
    }

    public Optional getTrackableSession(WebContext context) {
        return Optional.empty();
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        return false;
    }
}

