/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.profile;

import io.buji.pac4j.util.ShiroHelper;
import java.util.LinkedHashMap;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;

public class ShiroProfileManager
extends ProfileManager {
    public ShiroProfileManager(WebContext context, SessionStore sessionStore) {
        super(context, sessionStore);
    }

    protected void saveAll(LinkedHashMap<String, UserProfile> profiles, boolean saveInSession) {
        super.saveAll(profiles, saveInSession);
        try {
            ShiroHelper.populateSubject(profiles);
        }
        catch (AuthenticationException e) {
            super.removeProfiles();
            throw e;
        }
    }

    public void removeProfiles() {
        super.removeProfiles();
        SecurityUtils.getSubject().logout();
    }
}

