/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.subject;

import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;

public class Pac4jPrincipal
implements Principal,
Serializable {
    private final String principalNameAttribute;
    private final List<UserProfile> profiles;

    public Pac4jPrincipal(List<UserProfile> profiles) {
        this.profiles = profiles;
        this.principalNameAttribute = null;
    }

    public Pac4jPrincipal(List<UserProfile> profiles, String principalNameAttribute) {
        this.profiles = profiles;
        this.principalNameAttribute = CommonHelper.isBlank((String)principalNameAttribute) ? null : principalNameAttribute.trim();
    }

    public UserProfile getProfile() {
        return (UserProfile)ProfileHelper.flatIntoOneProfile(this.profiles).get();
    }

    public List<UserProfile> getProfiles() {
        return this.profiles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pac4jPrincipal that = (Pac4jPrincipal)o;
        return this.profiles != null ? this.profiles.equals(that.profiles) : that.profiles == null;
    }

    @Override
    public int hashCode() {
        return this.profiles != null ? this.profiles.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        UserProfile profile = this.getProfile();
        if (null == this.principalNameAttribute) {
            return profile.getId();
        }
        Object attrValue = profile.getAttribute(this.principalNameAttribute);
        return null == attrValue ? null : String.valueOf(attrValue);
    }
}

