/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.ads.mediation.caerulus.CaerulusCustomEventError;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.taurusx.tax.api.OnTaurusXBannerListener;
import com.taurusx.tax.api.TaurusXAdError;
import com.taurusx.tax.api.TaurusXBannerAds;
import com.taurusx.tax.core.AdSize;
import org.json.JSONObject;

public class CaerulusBannerEventLoader
implements MediationBannerAd {
    protected static final String TAG = "CaerulusAdapter";
    private final MediationBannerAdConfiguration mediationBannerAdConfiguration;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback;
    private MediationBannerAdCallback mediationBannerAdCallback;
    private TaurusXBannerAds taurusXBannerAds;

    public CaerulusBannerEventLoader(MediationBannerAdConfiguration mediationBannerAdConfiguration, MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback) {
        this.mediationBannerAdConfiguration = mediationBannerAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void loadAd() {
        Log.i((String)TAG, (String)"Begin loading banner ad.");
        String serverParameter = this.mediationBannerAdConfiguration.getServerParameters().getString("parameter");
        if (serverParameter == null || TextUtils.isEmpty((CharSequence)serverParameter)) {
            AdError error = CaerulusCustomEventError.createMissingServerParametersError();
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        Log.d((String)TAG, (String)("Received server parameter: " + serverParameter));
        try {
            JSONObject jsonObject = new JSONObject(serverParameter);
            if (!jsonObject.has("pid")) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            String adUnitId = jsonObject.getString("pid");
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            Context context = this.mediationBannerAdConfiguration.getContext();
            if (!(context instanceof Activity)) {
                AdError error = CaerulusCustomEventError.createContextError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            this.taurusXBannerAds = new TaurusXBannerAds((Activity)context);
            this.taurusXBannerAds.setAutoRefresh(false);
            this.taurusXBannerAds.setAdUnitId(adUnitId);
            String adSize = null;
            if (jsonObject.has("adsize")) {
                adSize = jsonObject.getString("adsize");
            }
            if (!TextUtils.isEmpty(adSize) && adSize.equalsIgnoreCase("banner_300_250")) {
                this.taurusXBannerAds.setAdSize(AdSize.Banner_300_250);
            } else {
                this.taurusXBannerAds.setAdSize(AdSize.Banner_320_50);
            }
            final boolean[] isAdsClicked = new boolean[]{false};
            this.taurusXBannerAds.setListener(new OnTaurusXBannerListener(){

                public void onAdLoaded() {
                    CaerulusBannerEventLoader.this.mediationBannerAdCallback = (MediationBannerAdCallback)CaerulusBannerEventLoader.this.mediationAdLoadCallback.onSuccess((Object)CaerulusBannerEventLoader.this);
                    Log.d((String)CaerulusBannerEventLoader.TAG, (String)"Received the banner ad.");
                }

                public void onAdShown() {
                    Log.d((String)CaerulusBannerEventLoader.TAG, (String)"The banner ad was shown.");
                    CaerulusBannerEventLoader.this.mediationBannerAdCallback.reportAdImpression();
                }

                public void onAdClicked() {
                    if (isAdsClicked[0]) {
                        Log.i((String)CaerulusBannerEventLoader.TAG, (String)"The banner ad was already clicked, ignore reporting.");
                        return;
                    }
                    Log.d((String)CaerulusBannerEventLoader.TAG, (String)"The banner ad was clicked.");
                    CaerulusBannerEventLoader.this.mediationBannerAdCallback.reportAdClicked();
                    isAdsClicked[0] = true;
                }

                public void onAdClosed() {
                    Log.d((String)CaerulusBannerEventLoader.TAG, (String)"The banner ad was closed.");
                    CaerulusBannerEventLoader.this.mediationBannerAdCallback.onAdClosed();
                }

                public void onAdFailedToLoad(TaurusXAdError taurusXAdError) {
                    AdError error = CaerulusCustomEventError.createAdNetworkError(taurusXAdError);
                    Log.e((String)CaerulusBannerEventLoader.TAG, (String)("Failed to fetch the banner ad. " + error.getMessage()));
                    CaerulusBannerEventLoader.this.mediationAdLoadCallback.onFailure(error);
                }
            });
            Log.i((String)TAG, (String)("Start fetching banner ad: " + adUnitId));
            this.taurusXBannerAds.loadBanner();
        }
        catch (Exception ex) {
            AdError error = CaerulusCustomEventError.createAdLoadExceptionError(ex);
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
        }
    }

    @NonNull
    public View getView() {
        return this.taurusXBannerAds.getAdView();
    }
}

