/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import com.google.android.gms.ads.AdError;
import com.taurusx.tax.api.TaurusXAdError;

public class CaerulusCustomEventError {
    public static final int ERROR_MISSING_SERVER_PARAMETERS = 101;
    public static final int ERROR_INVALID_SERVER_PARAMETERS = 102;
    public static final int ERROR_AD_LOAD_EXCEPTION = 103;
    public static final int ERROR_INVALID_CONTEXT = 104;
    public static final String ERROR_DOMAIN = "com.google.ads.mediation.caerulus";

    private CaerulusCustomEventError() {
    }

    public static AdError createMissingServerParametersError() {
        return new AdError(101, "Missing server parameters.", ERROR_DOMAIN);
    }

    public static AdError createInvalidServerParametersError(Exception ex) {
        return new AdError(102, "Invalid server parameters. " + ex.getMessage(), ERROR_DOMAIN);
    }

    public static AdError createMissingAppIdError() {
        return new AdError(102, "Missing appid in server parameter.", ERROR_DOMAIN);
    }

    public static AdError createMissingAdUnitIdError() {
        return new AdError(102, "Missing pid in server parameter.", ERROR_DOMAIN);
    }

    public static AdError createContextError() {
        return new AdError(104, "Context is invalid.", ERROR_DOMAIN);
    }

    public static AdError createAdLoadExceptionError(Exception ex) {
        return new AdError(103, "load ad failed with exception. " + ex.getMessage(), ERROR_DOMAIN);
    }

    public static AdError createWrongAdUnitConfigError() {
        return new AdError(102, "Wrong parameter in admob custom event mapping", ERROR_DOMAIN);
    }

    public static AdError createAdNetworkError(TaurusXAdError ex) {
        return new AdError(ex.getCode(), ex.getMessage(), ERROR_DOMAIN);
    }
}

