/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.caerulus.CaerulusCustomEventError;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.taurusx.tax.api.OnTaurusXInterstitialListener;
import com.taurusx.tax.api.TaurusXAdError;
import com.taurusx.tax.api.TaurusXInterstitialAds;
import org.json.JSONObject;

public class CaerulusInterstitialEventLoader
implements MediationInterstitialAd {
    protected static final String TAG = "CaerulusAdapter";
    private final MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration;
    private final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback;
    private MediationInterstitialAdCallback interstitialAdCallback;
    private TaurusXInterstitialAds taurusXInterstitialAds;

    public CaerulusInterstitialEventLoader(MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration, MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback) {
        this.mediationInterstitialAdConfiguration = mediationInterstitialAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void showAd(@NonNull Context context) {
        if (this.taurusXInterstitialAds != null) {
            this.taurusXInterstitialAds.show();
            Log.d((String)TAG, (String)"The interstitial ad was showing.");
        }
    }

    public void loadAd() {
        Log.i((String)TAG, (String)"Begin loading interstitial ad.");
        String serverParameter = this.mediationInterstitialAdConfiguration.getServerParameters().getString("parameter");
        if (serverParameter == null || TextUtils.isEmpty((CharSequence)serverParameter)) {
            AdError error = CaerulusCustomEventError.createMissingServerParametersError();
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        Log.d((String)TAG, (String)("Received server parameter: " + serverParameter));
        try {
            JSONObject jsonObject = new JSONObject(serverParameter);
            if (!jsonObject.has("pid")) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            String adUnitId = jsonObject.getString("pid");
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            Context context = this.mediationInterstitialAdConfiguration.getContext();
            this.taurusXInterstitialAds = new TaurusXInterstitialAds(context);
            this.taurusXInterstitialAds.setAdUnitId(adUnitId);
            final boolean[] isAdsClicked = new boolean[]{false};
            this.taurusXInterstitialAds.setListener(new OnTaurusXInterstitialListener(){

                public void onAdLoaded() {
                    Log.d((String)CaerulusInterstitialEventLoader.TAG, (String)"Received the interstitial ad.");
                    CaerulusInterstitialEventLoader.this.interstitialAdCallback = (MediationInterstitialAdCallback)CaerulusInterstitialEventLoader.this.mediationAdLoadCallback.onSuccess((Object)CaerulusInterstitialEventLoader.this);
                }

                public void onAdShown() {
                    Log.d((String)CaerulusInterstitialEventLoader.TAG, (String)"The interstitial ad was shown.");
                    CaerulusInterstitialEventLoader.this.interstitialAdCallback.reportAdImpression();
                }

                public void onAdClicked() {
                    if (isAdsClicked[0]) {
                        Log.i((String)CaerulusInterstitialEventLoader.TAG, (String)"The interstitial ad was already clicked, ignore reporting.");
                        return;
                    }
                    Log.d((String)CaerulusInterstitialEventLoader.TAG, (String)"The interstitial ad was clicked.");
                    CaerulusInterstitialEventLoader.this.interstitialAdCallback.reportAdClicked();
                    isAdsClicked[0] = true;
                }

                public void onAdClosed() {
                    Log.d((String)CaerulusInterstitialEventLoader.TAG, (String)"The interstitial ad was closed.");
                    CaerulusInterstitialEventLoader.this.interstitialAdCallback.onAdClosed();
                }

                public void onAdShowFailed(TaurusXAdError taurusXAdError) {
                    AdError error = CaerulusCustomEventError.createAdNetworkError(taurusXAdError);
                    Log.w((String)CaerulusInterstitialEventLoader.TAG, (String)("Failed to show the interstitial ad. " + error.getMessage()));
                    CaerulusInterstitialEventLoader.this.interstitialAdCallback.onAdFailedToShow(error);
                }

                public void onAdFailedToLoad(TaurusXAdError taurusXAdError) {
                    AdError error = CaerulusCustomEventError.createAdNetworkError(taurusXAdError);
                    Log.e((String)CaerulusInterstitialEventLoader.TAG, (String)("Failed to fetch the interstitial ad. " + error.getMessage()));
                    CaerulusInterstitialEventLoader.this.mediationAdLoadCallback.onFailure(error);
                }
            });
            Log.i((String)TAG, (String)("Start fetching interstitial ad: " + adUnitId));
            this.taurusXInterstitialAds.loadInterstitial();
        }
        catch (Exception ex) {
            AdError error = CaerulusCustomEventError.createAdLoadExceptionError(ex);
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
        }
    }
}

