/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.caerulus.CaerulusBannerEventLoader;
import com.google.ads.mediation.caerulus.CaerulusCustomEventError;
import com.google.ads.mediation.caerulus.CaerulusInterstitialEventLoader;
import com.google.ads.mediation.caerulus.CaerulusNativeEventLoader;
import com.google.ads.mediation.caerulus.CaerulusRewardedEventLoader;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.Adapter;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.taurusx.tax.api.TaurusXAds;
import java.util.List;
import org.json.JSONObject;

public class CaerulusMediationAdapter
extends Adapter {
    public static final String SERVER_PARAMETER_APP_ID = "appid";
    public static final String SERVER_PARAMETER_AD_UNIT_ID = "pid";
    public static final String SERVER_PARAMETER_AD_SIZE = "adsize";
    public static final String SERVER_PARAMETER_AUTO_SHOW = "auto_show";
    protected static final String TAG = "CaerulusAdapter";
    private CaerulusRewardedEventLoader caerulusRewardedEventLoader;
    private CaerulusInterstitialEventLoader caerulusInterstitialEventLoader;
    private CaerulusBannerEventLoader caerulusBannerEventLoader;
    private CaerulusNativeEventLoader caerulusNativeEventLoader;

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String versionString = TaurusXAds.getSdkVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            return new VersionInfo(major, minor, micro);
        }
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        String versionString = "1.0.16.7";
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            return new VersionInfo(major, minor, micro);
        }
        return new VersionInfo(0, 0, 0);
    }

    public void initialize(@NonNull Context context, @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> mediationConfigurations) {
        Log.d((String)TAG, (String)("mediationConfigurations size: " + mediationConfigurations.size()));
        for (MediationConfiguration mediationConfiguration : mediationConfigurations) {
            Bundle serverParameters = mediationConfiguration.getServerParameters();
            String parameter = serverParameters.getString("parameter");
            if (parameter == null || TextUtils.isEmpty((CharSequence)parameter)) {
                AdError error = CaerulusCustomEventError.createMissingServerParametersError();
                Log.w((String)TAG, (String)error.getMessage());
                initializationCompleteCallback.onInitializationFailed(error.getMessage());
                return;
            }
            try {
                String appId;
                JSONObject jsonObject = new JSONObject(parameter);
                if (jsonObject.has("ccpa")) {
                    int ccpa = jsonObject.getInt("ccpa");
                    TaurusXAds.setCCPADoNotSell((int)ccpa);
                }
                if (jsonObject.has("coppa")) {
                    int coppa = jsonObject.getInt("coppa");
                    TaurusXAds.setCOPPAIsAgeRestrictedUser((int)coppa);
                }
                if (jsonObject.has("gdpr")) {
                    int gdpr = jsonObject.getInt("gdpr");
                    TaurusXAds.setGDPRDataCollection((int)gdpr);
                }
                if (jsonObject.has("lgpd")) {
                    int lgpd = jsonObject.getInt("lgpd");
                    TaurusXAds.setLGPDConsent((int)lgpd);
                }
                if (TextUtils.isEmpty((CharSequence)(appId = jsonObject.getString(SERVER_PARAMETER_APP_ID)))) {
                    AdError error = CaerulusCustomEventError.createMissingAppIdError();
                    Log.w((String)TAG, (String)error.getMessage());
                    initializationCompleteCallback.onInitializationFailed(error.getMessage());
                    return;
                }
                TaurusXAds.init((Context)context, (String)appId);
                initializationCompleteCallback.onInitializationSucceeded();
                return;
            }
            catch (Exception ex) {
                AdError error = CaerulusCustomEventError.createInvalidServerParametersError(ex);
                Log.w((String)TAG, (String)error.getMessage());
                initializationCompleteCallback.onInitializationFailed(error.getMessage());
            }
        }
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.caerulusBannerEventLoader = new CaerulusBannerEventLoader(mediationBannerAdConfiguration, callback);
        this.caerulusBannerEventLoader.loadAd();
    }

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.caerulusInterstitialEventLoader = new CaerulusInterstitialEventLoader(mediationInterstitialAdConfiguration, callback);
        this.caerulusInterstitialEventLoader.loadAd();
    }

    public void loadNativeAd(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        this.caerulusNativeEventLoader = new CaerulusNativeEventLoader(mediationNativeAdConfiguration, callback);
        this.caerulusNativeEventLoader.loadAd();
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.caerulusRewardedEventLoader = new CaerulusRewardedEventLoader(mediationRewardedAdConfiguration, callback);
        this.caerulusRewardedEventLoader.loadAd();
    }
}

