/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.ads.mediation.caerulus.CaerulusCustomEventError;
import com.google.ads.mediation.caerulus.CaerulusUnifiedNativeAdMapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.taurusx.tax.api.OnTaurusXNativeListener;
import com.taurusx.tax.api.TaurusXAdError;
import com.taurusx.tax.api.TaurusXNativeAds;
import org.json.JSONObject;

public class CaerulusNativeEventLoader
extends UnifiedNativeAdMapper {
    protected static final String TAG = "CaerulusAdapter";
    private final MediationNativeAdConfiguration mediationNativeAdConfiguration;
    private final MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback;
    private MediationNativeAdCallback mediationNativeAdCallback;
    private TaurusXNativeAds taurusXNativeAds;

    public CaerulusNativeEventLoader(MediationNativeAdConfiguration mediationNativeAdConfiguration, MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback) {
        this.mediationNativeAdConfiguration = mediationNativeAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void loadAd() {
        Log.i((String)TAG, (String)"Begin loading native ad.");
        String serverParameter = this.mediationNativeAdConfiguration.getServerParameters().getString("parameter");
        if (serverParameter == null || TextUtils.isEmpty((CharSequence)serverParameter)) {
            AdError error = CaerulusCustomEventError.createMissingServerParametersError();
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        Log.d((String)TAG, (String)("Received server parameter: " + serverParameter));
        try {
            JSONObject jsonObject = new JSONObject(serverParameter);
            if (!jsonObject.has("pid")) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            String adUnitId = jsonObject.getString("pid");
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            boolean autoShow = false;
            if (jsonObject.has("auto_show")) {
                autoShow = jsonObject.getBoolean("auto_show");
            }
            Context context = this.mediationNativeAdConfiguration.getContext();
            this.taurusXNativeAds = new TaurusXNativeAds(context);
            this.taurusXNativeAds.setAdUnitId(adUnitId);
            final boolean[] isAdsClicked = new boolean[]{false};
            final boolean finalAutoShow = autoShow;
            this.taurusXNativeAds.setListener(new OnTaurusXNativeListener(){

                public void onAdLoaded(TaurusXNativeAds taurusXNativeAds) {
                    Log.d((String)CaerulusNativeEventLoader.TAG, (String)"Received the native ad.");
                    CaerulusNativeEventLoader.this.mediationNativeAdCallback = (MediationNativeAdCallback)CaerulusNativeEventLoader.this.mediationAdLoadCallback.onSuccess((Object)new CaerulusUnifiedNativeAdMapper(taurusXNativeAds, finalAutoShow));
                }

                public void onClicked() {
                    if (isAdsClicked[0]) {
                        Log.i((String)CaerulusNativeEventLoader.TAG, (String)"The native ad was already clicked, ignore reporting.");
                        return;
                    }
                    Log.d((String)CaerulusNativeEventLoader.TAG, (String)"The native ad was clicked.");
                    CaerulusNativeEventLoader.this.mediationNativeAdCallback.reportAdClicked();
                    isAdsClicked[0] = true;
                }

                public void onImpression() {
                    Log.d((String)CaerulusNativeEventLoader.TAG, (String)"The native ad was shown.");
                    CaerulusNativeEventLoader.this.mediationNativeAdCallback.reportAdImpression();
                }

                public void onAdFailedToLoad(TaurusXAdError taurusXAdError) {
                    AdError error = CaerulusCustomEventError.createAdNetworkError(taurusXAdError);
                    Log.e((String)CaerulusNativeEventLoader.TAG, (String)("Failed to fetch the native ad. " + error.getMessage()));
                    CaerulusNativeEventLoader.this.mediationAdLoadCallback.onFailure(error);
                }
            });
            Log.i((String)TAG, (String)("Start fetching native ad: " + adUnitId));
            this.taurusXNativeAds.loadNative();
        }
        catch (Exception ex) {
            AdError error = CaerulusCustomEventError.createAdLoadExceptionError(ex);
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
        }
    }
}

