/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.caerulus.CaerulusCustomEventError;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.taurusx.tax.api.OnTaurusXRewardListener;
import com.taurusx.tax.api.TaurusXAdError;
import com.taurusx.tax.api.TaurusXRewardedAds;
import org.json.JSONObject;

public class CaerulusRewardedEventLoader
implements MediationRewardedAd {
    protected static final String TAG = "CaerulusAdapter";
    private final MediationRewardedAdConfiguration mediationRewardedAdConfiguration;
    private final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback;
    private MediationRewardedAdCallback rewardedAdCallback;
    private TaurusXRewardedAds taurusXRewardedAds;

    public CaerulusRewardedEventLoader(MediationRewardedAdConfiguration mediationRewardedAdConfiguration, MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        this.mediationRewardedAdConfiguration = mediationRewardedAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
    }

    public void showAd(@NonNull Context context) {
        if (this.taurusXRewardedAds != null) {
            this.taurusXRewardedAds.showReward();
            Log.d((String)TAG, (String)"The rewarded ad was showing.");
        }
    }

    public void loadAd() {
        Log.i((String)TAG, (String)"Begin loading rewarded ad.");
        String serverParameter = this.mediationRewardedAdConfiguration.getServerParameters().getString("parameter");
        if (serverParameter == null || TextUtils.isEmpty((CharSequence)serverParameter)) {
            AdError error = CaerulusCustomEventError.createMissingServerParametersError();
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(serverParameter);
            if (!jsonObject.has("pid")) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            String adUnitId = jsonObject.getString("pid");
            if (TextUtils.isEmpty((CharSequence)adUnitId)) {
                AdError error = CaerulusCustomEventError.createMissingAdUnitIdError();
                Log.w((String)TAG, (String)error.getMessage());
                this.mediationAdLoadCallback.onFailure(error);
                return;
            }
            Context context = this.mediationRewardedAdConfiguration.getContext();
            this.taurusXRewardedAds = new TaurusXRewardedAds(context);
            this.taurusXRewardedAds.setAdUnitId(adUnitId);
            final boolean[] isAdsClicked = new boolean[]{false};
            this.taurusXRewardedAds.setListener(new OnTaurusXRewardListener(){

                public void onAdLoaded() {
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"Received the rewarded ad.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback = (MediationRewardedAdCallback)CaerulusRewardedEventLoader.this.mediationAdLoadCallback.onSuccess((Object)CaerulusRewardedEventLoader.this);
                }

                public void onAdShown() {
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad was shown.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onAdOpened();
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onVideoStart();
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.reportAdImpression();
                }

                public void onAdClicked() {
                    if (isAdsClicked[0]) {
                        Log.i((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad was already clicked, ignore reporting.");
                        return;
                    }
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad was clicked.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.reportAdClicked();
                    isAdsClicked[0] = true;
                }

                public void onAdClosed() {
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad was closed.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onAdClosed();
                }

                public void onAdShowFailed(TaurusXAdError taurusXAdError) {
                    AdError error = CaerulusCustomEventError.createAdNetworkError(taurusXAdError);
                    Log.w((String)CaerulusRewardedEventLoader.TAG, (String)("Failed to show the rewarded ad. " + error.getMessage()));
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onAdFailedToShow(error);
                }

                public void onAdFailedToLoad(TaurusXAdError taurusXAdError) {
                    AdError error = CaerulusCustomEventError.createAdNetworkError(taurusXAdError);
                    Log.e((String)CaerulusRewardedEventLoader.TAG, (String)("Failed to fetch the rewarded ad. " + error.getMessage()));
                    CaerulusRewardedEventLoader.this.mediationAdLoadCallback.onFailure(error);
                }

                public void onVideoStart() {
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad video was started.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onVideoStart();
                }

                public void onVideoCompleted() {
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad video was completed.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onVideoComplete();
                }

                public void onRewarded(final TaurusXRewardedAds.RewardItem rewardItem) {
                    Log.d((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad video was rewarded.");
                    CaerulusRewardedEventLoader.this.rewardedAdCallback.onUserEarnedReward(new RewardItem(){

                        public int getAmount() {
                            return rewardItem.getAmount();
                        }

                        @NonNull
                        public String getType() {
                            return rewardItem.getType();
                        }
                    });
                }

                public void onRewardFailed() {
                    Log.w((String)CaerulusRewardedEventLoader.TAG, (String)"The rewarded ad reward was failed.");
                }
            });
            Log.i((String)TAG, (String)("Start fetching rewarded ad: " + adUnitId));
            this.taurusXRewardedAds.loadReward();
        }
        catch (Exception ex) {
            AdError error = CaerulusCustomEventError.createAdLoadExceptionError(ex);
            Log.w((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
        }
    }
}

