/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.caerulus;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.google.ads.mediation.caerulus.CaerulusNativeMappedImage;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.taurusx.tax.api.MediaView;
import com.taurusx.tax.api.TaurusXNativeAds;
import java.util.ArrayList;
import java.util.Map;

public class CaerulusUnifiedNativeAdMapper
extends UnifiedNativeAdMapper {
    protected static final String TAG = "CaerulusAdapter";
    private final TaurusXNativeAds taurusXNativeAds;
    private final boolean autoShow;

    public CaerulusUnifiedNativeAdMapper(TaurusXNativeAds taurusXNativeAds, boolean autoShow) {
        this.taurusXNativeAds = taurusXNativeAds;
        this.autoShow = autoShow;
        this.setHeadline(taurusXNativeAds.getTitle());
        this.setBody(taurusXNativeAds.getDesc());
        this.setCallToAction(taurusXNativeAds.getCallToAction());
        String iconUrl = taurusXNativeAds.getIconUrl();
        if (!TextUtils.isEmpty((CharSequence)iconUrl)) {
            this.setIcon(new CaerulusNativeMappedImage(null, Uri.parse((String)iconUrl), 1.0));
        }
        this.setOverrideClickHandling(false);
        this.setOverrideImpressionRecording(false);
    }

    public void recordImpression() {
    }

    public void handleClick(View view) {
    }

    public void trackViews(View containerView, Map<String, View> clickableAssetViews, Map<String, View> nonClickableAssetViews) {
        super.trackViews(containerView, clickableAssetViews, nonClickableAssetViews);
        if (this.autoShow) {
            Log.i((String)TAG, (String)"Show native ad with internal views.");
            if (this.taurusXNativeAds != null && this.taurusXNativeAds.isReady()) {
                this.taurusXNativeAds.showNative(containerView.getContext(), (ViewGroup)containerView);
            } else {
                Log.w((String)TAG, (String)"Native ad is not ready.");
            }
            return;
        }
        Log.i((String)TAG, (String)"Show native ad with custom views.");
        ImageView iconView = null;
        com.google.android.gms.ads.nativead.MediaView mediaView = null;
        ArrayList<View> views = new ArrayList<View>();
        for (Map.Entry<String, View> clickableAssetView : clickableAssetViews.entrySet()) {
            views.add(clickableAssetView.getValue());
            if (clickableAssetView.getValue() instanceof ImageView) {
                iconView = (ImageView)clickableAssetView.getValue();
                continue;
            }
            if (!(clickableAssetView.getValue() instanceof com.google.android.gms.ads.nativead.MediaView)) continue;
            mediaView = (com.google.android.gms.ads.nativead.MediaView)clickableAssetView.getValue();
        }
        MediaView taurusxMediaView = null;
        if (mediaView != null) {
            taurusxMediaView = new MediaView(mediaView.getContext());
            mediaView.addView((View)taurusxMediaView);
        }
        for (Map.Entry<String, View> nonClickableAssetView : nonClickableAssetViews.entrySet()) {
            views.add(nonClickableAssetView.getValue());
        }
        this.taurusXNativeAds.registerViewForInteraction((ViewGroup)containerView, iconView, taurusxMediaView, views);
    }

    public void untrackView(View view) {
        super.untrackView(view);
    }
}

