/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.impl.BuilderUtils;
import io.camunda.client.impl.CamundaClientImpl;
import io.camunda.client.impl.CamundaObjectMapper;
import io.camunda.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.client.impl.util.ClientPropertiesValidationUtils;
import io.camunda.client.impl.util.DataSizeUtil;
import io.camunda.client.impl.util.Environment;
import io.grpc.ClientInterceptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;

public final class CamundaClientBuilderImpl
implements CamundaClientBuilder,
CamundaClientConfiguration {
    public static final String DEFAULT_GATEWAY_ADDRESS = "0.0.0.0:26500";
    public static final URI DEFAULT_GRPC_ADDRESS = CamundaClientBuilderImpl.getURIFromString("http://0.0.0.0:26500");
    public static final URI DEFAULT_REST_ADDRESS = CamundaClientBuilderImpl.getURIFromString("http://0.0.0.0:8080");
    public static final String DEFAULT_JOB_WORKER_NAME_VAR = "default";
    private static final String TENANT_ID_LIST_SEPARATOR = ",";
    private static final boolean DEFAULT_PREFER_REST_OVER_GRPC = false;
    private boolean applyEnvironmentVariableOverrides = true;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final List<AsyncExecChainHandler> chainHandlers = new ArrayList<AsyncExecChainHandler>();
    private String gatewayAddress = "0.0.0.0:26500";
    private URI restAddress = DEFAULT_REST_ADDRESS;
    private URI grpcAddress = DEFAULT_GRPC_ADDRESS;
    private boolean preferRestOverGrpc = false;
    private String defaultTenantId = "<default>";
    private List<String> defaultJobWorkerTenantIds = Collections.singletonList("<default>");
    private int jobWorkerMaxJobsActive = 32;
    private int numJobWorkerExecutionThreads = 1;
    private String defaultJobWorkerName = "default";
    private Duration defaultJobTimeout = Duration.ofMinutes(5L);
    private Duration defaultJobPollInterval = Duration.ofMillis(100L);
    private Duration defaultMessageTimeToLive = Duration.ofHours(1L);
    private Duration defaultRequestTimeout = Duration.ofSeconds(10L);
    private boolean usePlaintextConnection = false;
    private String certificatePath;
    private CredentialsProvider credentialsProvider;
    private Duration keepAlive = Duration.ofSeconds(45L);
    private JsonMapper jsonMapper = new CamundaObjectMapper();
    private String overrideAuthority;
    private int maxMessageSize = 0x500000;
    private int maxMetadataSize = 16384;
    private boolean streamEnabled = false;
    private boolean grpcAddressUsed = true;
    private ScheduledExecutorService jobWorkerExecutor;
    private boolean ownsJobWorkerExecutor;
    private boolean useDefaultRetryPolicy;

    @Override
    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    @Override
    public URI getRestAddress() {
        return this.restAddress;
    }

    @Override
    public URI getGrpcAddress() {
        return this.grpcAddress;
    }

    @Override
    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    @Override
    public List<String> getDefaultJobWorkerTenantIds() {
        return this.defaultJobWorkerTenantIds;
    }

    @Override
    public int getNumJobWorkerExecutionThreads() {
        return this.numJobWorkerExecutionThreads;
    }

    @Override
    public int getDefaultJobWorkerMaxJobsActive() {
        return this.jobWorkerMaxJobsActive;
    }

    @Override
    public String getDefaultJobWorkerName() {
        return this.defaultJobWorkerName;
    }

    @Override
    public Duration getDefaultJobTimeout() {
        return this.defaultJobTimeout;
    }

    @Override
    public Duration getDefaultJobPollInterval() {
        return this.defaultJobPollInterval;
    }

    @Override
    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    @Override
    public Duration getDefaultRequestTimeout() {
        return this.defaultRequestTimeout;
    }

    @Override
    public boolean isPlaintextConnectionEnabled() {
        return this.usePlaintextConnection;
    }

    @Override
    public String getCaCertificatePath() {
        return this.certificatePath;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public List<AsyncExecChainHandler> getChainHandlers() {
        return this.chainHandlers;
    }

    @Override
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public String getOverrideAuthority() {
        return this.overrideAuthority;
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public int getMaxMetadataSize() {
        return this.maxMetadataSize;
    }

    @Override
    public ScheduledExecutorService jobWorkerExecutor() {
        return this.jobWorkerExecutor;
    }

    @Override
    public boolean ownsJobWorkerExecutor() {
        return this.ownsJobWorkerExecutor;
    }

    @Override
    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.streamEnabled;
    }

    @Override
    public boolean useDefaultRetryPolicy() {
        return this.useDefaultRetryPolicy;
    }

    @Override
    public boolean preferRestOverGrpc() {
        return this.preferRestOverGrpc;
    }

    @Override
    public CamundaClientBuilder withProperties(Properties properties) {
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.applyEnvironmentVariableOverrides(Boolean.parseBoolean(value)), "camunda.client.applyEnvironmentVariableOverrides", "zeebe.client.applyEnvironmentVariableOverrides");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.grpcAddress(CamundaClientBuilderImpl.getURIFromString(value)), "camunda.client.gateway.grpc.address", "zeebe.client.gateway.grpc.address");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.restAddress(CamundaClientBuilderImpl.getURIFromString(value)), "camunda.client.gateway.rest.address", "zeebe.client.gateway.rest.address");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::gatewayAddress, "zeebe.client.gateway.address");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.preferRestOverGrpc(Boolean.parseBoolean(value)), "camunda.client.gateway.preferRestOverGrpc", "zeebe.client.gateway.preferRestOverGrpc");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::defaultTenantId, "camunda.client.tenantId", "zeebe.client.tenantId");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultJobWorkerTenantIds(Arrays.asList(value.split(TENANT_ID_LIST_SEPARATOR))), "camunda.client.worker.tenantIds", "zeebe.client.worker.tenantIds");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.numJobWorkerExecutionThreads(Integer.parseInt(value)), "camunda.client.worker.threads", "zeebe.client.worker.threads");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultJobWorkerMaxJobsActive(Integer.parseInt(value)), "camunda.client.worker.maxJobsActive", "zeebe.client.worker.maxJobsActive");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::defaultJobWorkerName, "camunda.client.worker.name");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultJobTimeout(Duration.ofMillis(Long.parseLong(value))), "camunda.client.job.timeout", "zeebe.client.job.timeout");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultJobPollInterval(Duration.ofMillis(Long.parseLong(value))), "camunda.client.job.pollinterval", "zeebe.client.job.pollinterval");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultMessageTimeToLive(Duration.ofMillis(Long.parseLong(value))), "camunda.client.message.timeToLive", "zeebe.client.message.timeToLive");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultRequestTimeout(Duration.ofMillis(Long.parseLong(value))), "camunda.client.requestTimeout", "zeebe.client.requestTimeout");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> {
            if (!"false".equalsIgnoreCase((String)value)) {
                this.usePlaintext();
            }
        }, "camunda.client.security.plaintext", "zeebe.client.security.plaintext");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::caCertificatePath, "camunda.client.security.certpath", "zeebe.client.security.certpath");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::keepAlive, "camunda.client.keepalive");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::overrideAuthority, "camunda.client.overrideauthority", "zeebe.client.overrideauthority");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.maxMessageSize(DataSizeUtil.parse(value)), "camunda.client.maxMessageSize", "zeebe.client.maxMessageSize");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.maxMetadataSize(DataSizeUtil.parse(value)), "camunda.client.maxMetadataSize", "zeebe.client.maxMetadataSize");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(value)), "camunda.client.worker.stream.enabled", "zeebe.client.worker.stream.enabled");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.useDefaultRetryPolicy(Boolean.parseBoolean(value)), "camunda.client.useDefaultRetryPolicy", "zeebe.client.useDefaultRetryPolicy");
        return this;
    }

    @Override
    public CamundaClientBuilder applyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.applyEnvironmentVariableOverrides = applyEnvironmentVariableOverrides;
        return this;
    }

    @Override
    public CamundaClientBuilder gatewayAddress(String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
        this.grpcAddressUsed = false;
        return this;
    }

    @Override
    public CamundaClientBuilder restAddress(URI restAddress) {
        ClientPropertiesValidationUtils.checkIfUriIsAbsolute(restAddress, "restAddress");
        this.restAddress = restAddress;
        return this;
    }

    @Override
    public CamundaClientBuilder grpcAddress(URI grpcAddress) {
        ClientPropertiesValidationUtils.checkIfUriIsAbsolute(grpcAddress, "grpcAddress");
        this.grpcAddress = grpcAddress;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultTenantId(String tenantId) {
        this.defaultTenantId = tenantId;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerTenantIds(List<String> tenantIds) {
        this.defaultJobWorkerTenantIds = tenantIds;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.jobWorkerMaxJobsActive = maxJobsActive;
        return this;
    }

    @Override
    public CamundaClientBuilder numJobWorkerExecutionThreads(int numSubscriptionThreads) {
        this.numJobWorkerExecutionThreads = numSubscriptionThreads;
        return this;
    }

    @Override
    public CamundaClientBuilder jobWorkerExecutor(ScheduledExecutorService executor, boolean takeOwnership) {
        this.jobWorkerExecutor = executor;
        this.ownsJobWorkerExecutor = takeOwnership;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerName(String workerName) {
        if (workerName != null) {
            this.defaultJobWorkerName = workerName;
        }
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobTimeout(Duration timeout) {
        this.defaultJobTimeout = timeout;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobPollInterval(Duration pollInterval) {
        this.defaultJobPollInterval = pollInterval;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultMessageTimeToLive(Duration timeToLive) {
        this.defaultMessageTimeToLive = timeToLive;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultRequestTimeout(Duration requestTimeout) {
        this.defaultRequestTimeout = requestTimeout;
        return this;
    }

    @Override
    public CamundaClientBuilder usePlaintext() {
        return this.usePlaintext(true);
    }

    @Override
    public CamundaClientBuilder caCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    @Override
    public CamundaClientBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    @Override
    public CamundaClientBuilder keepAlive(Duration keepAlive) {
        if (keepAlive.isNegative() || keepAlive.isZero()) {
            throw new IllegalArgumentException("The keep alive must be a positive number.");
        }
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public CamundaClientBuilder withInterceptors(ClientInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    @Override
    public CamundaClientBuilder withChainHandlers(AsyncExecChainHandler ... chainHandler) {
        this.chainHandlers.addAll(Arrays.asList(chainHandler));
        return this;
    }

    @Override
    public CamundaClientBuilder withJsonMapper(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    @Override
    public CamundaClientBuilder overrideAuthority(String authority) {
        this.overrideAuthority = authority;
        return this;
    }

    @Override
    public CamundaClientBuilder maxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    @Override
    public CamundaClientBuilder maxMetadataSize(int maxMetadataSize) {
        this.maxMetadataSize = maxMetadataSize;
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerStreamEnabled(boolean streamEnabled) {
        this.streamEnabled = streamEnabled;
        return this;
    }

    @Override
    public CamundaClientBuilder useDefaultRetryPolicy(boolean useDefaultRetryPolicy) {
        this.useDefaultRetryPolicy = useDefaultRetryPolicy;
        return this;
    }

    @Override
    public CamundaClientBuilder preferRestOverGrpc(boolean preferRestOverGrpc) {
        this.preferRestOverGrpc = preferRestOverGrpc;
        return this;
    }

    @Override
    public CamundaClient build() {
        if (this.applyEnvironmentVariableOverrides) {
            this.applyOverrides();
        }
        if (!this.grpcAddressUsed) {
            String scheme = this.usePlaintextConnection ? "http://" : "https://";
            this.grpcAddress(CamundaClientBuilderImpl.getURIFromString(scheme + this.getGatewayAddress()));
        }
        return new CamundaClientImpl(this);
    }

    private CamundaClientBuilder usePlaintext(boolean usePlaintext) {
        this.usePlaintextConnection = usePlaintext;
        return this;
    }

    private void keepAlive(String keepAlive) {
        this.keepAlive(Duration.ofMillis(Long.parseUnsignedLong(keepAlive)));
    }

    private void applyOverrides() {
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.usePlaintext(Boolean.parseBoolean(value)), "CAMUNDA_INSECURE_CONNECTION", "ZEEBE_INSECURE_CONNECTION");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::caCertificatePath, "CAMUNDA_CA_CERTIFICATE_PATH", "ZEEBE_CA_CERTIFICATE_PATH");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::keepAlive, "CAMUNDA_KEEP_ALIVE", "ZEEBE_KEEP_ALIVE");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::overrideAuthority, "CAMUNDA_OVERRIDE_AUTHORITY", "ZEEBE_OVERRIDE_AUTHORITY");
        if (this.shouldUseDefaultCredentialsProvider()) {
            this.credentialsProvider = this.createDefaultCredentialsProvider();
        }
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.grpcAddress(CamundaClientBuilderImpl.getURIFromString(value)), "CAMUNDA_GRPC_ADDRESS", "ZEEBE_GRPC_ADDRESS");
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.restAddress(CamundaClientBuilderImpl.getURIFromString(value)), "CAMUNDA_REST_ADDRESS", "ZEEBE_REST_ADDRESS");
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.preferRestOverGrpc(Boolean.parseBoolean(value)), "CAMUNDA_PREFER_REST", "ZEEBE_PREFER_REST");
        BuilderUtils.applyEnvironmentValueIfNotNull(this::defaultTenantId, "CAMUNDA_DEFAULT_TENANT_ID", "ZEEBE_DEFAULT_TENANT_ID");
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.defaultJobWorkerTenantIds(Arrays.asList(value.split(TENANT_ID_LIST_SEPARATOR))), "CAMUNDA_DEFAULT_JOB_WORKER_TENANT_IDS", "ZEEBE_DEFAULT_JOB_WORKER_TENANT_IDS");
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(value)), "CAMUNDA_CLIENT_WORKER_STREAM_ENABLED", "ZEEBE_CLIENT_WORKER_STREAM_ENABLED");
        BuilderUtils.applyEnvironmentValueIfNotNull(value -> this.useDefaultRetryPolicy(Boolean.parseBoolean(value)), "CAMUNDA_CLIENT_USE_DEFAULT_RETRY_POLICY", "ZEEBE_CLIENT_USE_DEFAULT_RETRY_POLICY");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        BuilderUtils.appendProperty(sb, "gatewayAddress", this.gatewayAddress);
        BuilderUtils.appendProperty(sb, "grpcAddress", this.grpcAddress);
        BuilderUtils.appendProperty(sb, "restAddress", this.restAddress);
        BuilderUtils.appendProperty(sb, "defaultTenantId", this.defaultTenantId);
        BuilderUtils.appendProperty(sb, "jobWorkerMaxJobsActive", this.jobWorkerMaxJobsActive);
        BuilderUtils.appendProperty(sb, "numJobWorkerExecutionThreads", this.numJobWorkerExecutionThreads);
        BuilderUtils.appendProperty(sb, "defaultJobWorkerName", this.defaultJobWorkerName);
        BuilderUtils.appendProperty(sb, "defaultJobTimeout", this.defaultJobTimeout);
        BuilderUtils.appendProperty(sb, "defaultJobPollInterval", this.defaultJobPollInterval);
        BuilderUtils.appendProperty(sb, "defaultMessageTimeToLive", this.defaultMessageTimeToLive);
        BuilderUtils.appendProperty(sb, "defaultRequestTimeout", this.defaultRequestTimeout);
        BuilderUtils.appendProperty(sb, "overrideAuthority", this.overrideAuthority);
        BuilderUtils.appendProperty(sb, "maxMessageSize", this.maxMessageSize);
        BuilderUtils.appendProperty(sb, "maxMetadataSize", this.maxMetadataSize);
        BuilderUtils.appendProperty(sb, "jobWorkerExecutor", this.jobWorkerExecutor);
        BuilderUtils.appendProperty(sb, "ownsJobWorkerExecutor", this.ownsJobWorkerExecutor);
        BuilderUtils.appendProperty(sb, "streamEnabled", this.streamEnabled);
        BuilderUtils.appendProperty(sb, "preferRestOverGrpc", this.preferRestOverGrpc);
        return sb.toString();
    }

    private boolean shouldUseDefaultCredentialsProvider() {
        return !(this.credentialsProvider != null || !Environment.system().isDefined("CAMUNDA_CLIENT_ID") && !Environment.system().isDefined("ZEEBE_CLIENT_ID") || !Environment.system().isDefined("CAMUNDA_CLIENT_SECRET") && !Environment.system().isDefined("ZEEBE_CLIENT_SECRET"));
    }

    private CredentialsProvider createDefaultCredentialsProvider() {
        OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
        int separatorIndex = this.gatewayAddress.lastIndexOf(58);
        if (separatorIndex > 0) {
            builder.audience(this.gatewayAddress.substring(0, separatorIndex));
        }
        return builder.build();
    }

    private static URI getURIFromString(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse URI string", e);
        }
    }
}

