/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignGroupToTenantCommandStep1;
import io.camunda.client.api.response.AssignGroupToTenantResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class AssignGroupToTenantCommandImpl
implements AssignGroupToTenantCommandStep1 {
    private final HttpClient httpClient;
    private final String tenantId;
    private final RequestConfig.Builder httpRequestConfig;
    private long groupKey;

    public AssignGroupToTenantCommandImpl(HttpClient httpClient, String tenantId) {
        this.httpClient = httpClient;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignGroupToTenantCommandStep1 groupKey(long groupKey) {
        ArgumentUtil.ensureNotNull("groupKey", groupKey);
        this.groupKey = groupKey;
        return this;
    }

    public AssignGroupToTenantCommandStep1 requestTimeout(Duration timeout) {
        this.httpRequestConfig.setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignGroupToTenantResponse> send() {
        ArgumentUtil.ensureNotNull("groupKey", this.groupKey);
        HttpCamundaFuture<AssignGroupToTenantResponse> result = new HttpCamundaFuture<AssignGroupToTenantResponse>();
        this.httpClient.put("/tenants/" + this.tenantId + "/groups/" + this.groupKey, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

