/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignUserToGroupCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignUserToGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignUserToGroupCommandImpl
implements AssignUserToGroupCommandStep1 {
    private final long groupKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private long userKey;

    public AssignUserToGroupCommandImpl(long groupKey, HttpClient httpClient) {
        this.groupKey = groupKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignUserToGroupCommandStep1 userKey(long userKey) {
        ArgumentUtil.ensureNotNull("userKey", userKey);
        this.userKey = userKey;
        return this;
    }

    @Override
    public FinalCommandStep<AssignUserToGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignUserToGroupResponse> send() {
        ArgumentUtil.ensureNotNull("userKey", this.userKey);
        HttpCamundaFuture<AssignUserToGroupResponse> result = new HttpCamundaFuture<AssignUserToGroupResponse>();
        this.httpClient.post("/groups/" + this.groupKey + "/users/" + this.userKey, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

