/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CompleteJobCommandStep1;
import io.camunda.client.api.command.CompleteJobResult;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CompleteJobResponse;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.command.CommandWithVariables;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CompleteJobResponseImpl;
import io.camunda.client.protocol.rest.JobCompletionRequest;
import io.camunda.client.protocol.rest.JobResult;
import io.camunda.client.protocol.rest.JobResultCorrections;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CompleteJobCommandImpl
extends CommandWithVariables<CompleteJobCommandStep1>
implements CompleteJobCommandStep1,
CompleteJobCommandStep1.CompleteJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CompleteJobRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JobCompletionRequest httpRequestObject;
    private boolean useRest;
    private final long jobKey;
    private final JsonMapper jsonMapper;
    private GatewayOuterClass.JobResult.Builder resultGrpc;
    private JobResult resultRest;
    private GatewayOuterClass.JobResultCorrections.Builder correctionsGrpc;
    private JobResultCorrections correctionsRest;

    public CompleteJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.CompleteJobRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(key);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobCompletionRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = key;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public FinalCommandStep<CompleteJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CompleteJobResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 withResult() {
        this.initJobResult();
        return this;
    }

    @Override
    public CompleteJobCommandStep1 withResult(CompleteJobResult jobResult) {
        return this.withResult().deny(jobResult.isDenied()).deniedReason(jobResult.getDeniedReason()).correct(jobResult.getCorrections()).resultDone();
    }

    @Override
    public CompleteJobCommandStep1 withResult(UnaryOperator<CompleteJobResult> jobResultModifier) {
        this.initJobResult();
        CompleteJobResult reconstructedJobResult = new CompleteJobResult().deny(this.resultRest.getDenied() != null ? this.resultRest.getDenied() : false).deniedReason(this.resultRest.getDeniedReason()).correct(this.reconstructCorrections());
        return this.withResult((CompleteJobResult)jobResultModifier.apply(reconstructedJobResult));
    }

    private void initJobResult() {
        this.resultRest = new JobResult();
        this.correctionsRest = new JobResultCorrections();
        this.resultRest.setCorrections(this.correctionsRest);
        this.httpRequestObject.setResult(this.resultRest);
        this.resultGrpc = GatewayOuterClass.JobResult.newBuilder();
        this.correctionsGrpc = GatewayOuterClass.JobResultCorrections.newBuilder();
        this.resultGrpc.setCorrections(this.correctionsGrpc);
        this.grpcRequestObjectBuilder.setResult(this.resultGrpc);
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 deny(boolean isDenied) {
        this.resultRest.setDenied(isDenied);
        this.resultGrpc.setDenied(isDenied);
        this.onResultChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 deny(boolean isDenied, String deniedReason) {
        return this.deny(isDenied).deniedReason(deniedReason);
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 deniedReason(String deniedReason) {
        this.resultRest.setDeniedReason(deniedReason);
        this.resultGrpc.setDeniedReason(deniedReason == null ? "" : deniedReason);
        this.onResultChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correct(io.camunda.client.api.command.JobResultCorrections corrections) {
        return this.correctAssignee(corrections.getAssignee()).correctCandidateGroups(corrections.getCandidateGroups()).correctCandidateUsers(corrections.getCandidateUsers()).correctDueDate(corrections.getDueDate()).correctFollowUpDate(corrections.getFollowUpDate()).correctPriority(corrections.getPriority());
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correct(UnaryOperator<io.camunda.client.api.command.JobResultCorrections> corrections) {
        io.camunda.client.api.command.JobResultCorrections reconstructedCorrections = this.reconstructCorrections();
        return this.correct((io.camunda.client.api.command.JobResultCorrections)corrections.apply(reconstructedCorrections));
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correctAssignee(String assignee) {
        this.correctionsRest.setAssignee(assignee);
        if (assignee == null) {
            this.correctionsGrpc.clearAssignee();
        } else {
            this.correctionsGrpc.setAssignee(assignee);
        }
        this.onCorrectionsChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correctDueDate(String dueDate) {
        this.correctionsRest.setDueDate(dueDate);
        if (dueDate == null) {
            this.correctionsGrpc.clearDueDate();
        } else {
            this.correctionsGrpc.setDueDate(dueDate);
        }
        this.onCorrectionsChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correctFollowUpDate(String followUpDate) {
        this.correctionsRest.setFollowUpDate(followUpDate);
        if (followUpDate == null) {
            this.correctionsGrpc.clearFollowUpDate();
        } else {
            this.correctionsGrpc.setFollowUpDate(followUpDate);
        }
        this.onCorrectionsChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correctCandidateUsers(List<String> candidateUsers) {
        this.correctionsRest.setCandidateUsers(candidateUsers);
        if (candidateUsers == null) {
            this.correctionsGrpc.clearCandidateUsers();
        } else {
            this.correctionsGrpc.setCandidateUsers(GatewayOuterClass.StringList.newBuilder().addAllValues(candidateUsers).build());
        }
        this.onCorrectionsChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correctCandidateGroups(List<String> candidateGroups) {
        this.correctionsRest.setCandidateGroups(candidateGroups);
        if (candidateGroups == null) {
            this.correctionsGrpc.clearCandidateGroups();
        } else {
            this.correctionsGrpc.setCandidateGroups(GatewayOuterClass.StringList.newBuilder().addAllValues(candidateGroups).build());
        }
        this.onCorrectionsChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1.CompleteJobCommandStep2 correctPriority(Integer priority) {
        this.correctionsRest.setPriority(priority);
        if (priority == null) {
            this.correctionsGrpc.clearPriority();
        } else {
            this.correctionsGrpc.setPriority(priority.intValue());
        }
        this.onCorrectionsChange();
        return this;
    }

    @Override
    public CompleteJobCommandStep1 resultDone() {
        return this;
    }

    private io.camunda.client.api.command.JobResultCorrections reconstructCorrections() {
        return new io.camunda.client.api.command.JobResultCorrections().assignee(this.correctionsRest.getAssignee()).candidateGroups(this.correctionsRest.getCandidateGroups()).candidateUsers(this.correctionsRest.getCandidateUsers()).dueDate(this.correctionsRest.getDueDate()).followUpDate(this.correctionsRest.getFollowUpDate()).priority(this.correctionsRest.getPriority());
    }

    private void onResultChange() {
        this.grpcRequestObjectBuilder.setResult(this.resultGrpc);
    }

    private void onCorrectionsChange() {
        this.resultGrpc.setCorrections(this.correctionsGrpc);
        this.onResultChange();
    }

    @Override
    public CompleteJobCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public CompleteJobCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    private CamundaFuture<CompleteJobResponse> sendRestRequest() {
        HttpCamundaFuture<CompleteJobResponse> result = new HttpCamundaFuture<CompleteJobResponse>();
        this.httpClient.post("/jobs/" + this.jobKey + "/completion", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private CamundaFuture<CompleteJobResponse> sendGrpcRequest() {
        GatewayOuterClass.CompleteJobRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse> future = new RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse>(CompleteJobResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).completeJob(request, streamObserver);
    }

    @Override
    protected CompleteJobCommandStep1 setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.jsonMapper.fromJsonAsMap(variables));
        }
        return this;
    }
}

