/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignGroupFromTenantCommandStep1;
import io.camunda.client.api.response.UnassignGroupFromTenantResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class UnassignGroupFromTenantCommandImpl
implements UnassignGroupFromTenantCommandStep1 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String tenantId;
    private long groupKey;

    public UnassignGroupFromTenantCommandImpl(HttpClient httpClient, String tenantId) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.tenantId = tenantId;
    }

    @Override
    public UnassignGroupFromTenantCommandStep1 groupKey(long groupKey) {
        ArgumentUtil.ensureNotNull("groupKey", groupKey);
        this.groupKey = groupKey;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignGroupFromTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignGroupFromTenantResponse> send() {
        ArgumentUtil.ensureNotNull("groupKey", this.groupKey);
        HttpCamundaFuture<UnassignGroupFromTenantResponse> result = new HttpCamundaFuture<UnassignGroupFromTenantResponse>();
        String endpoint = String.format("/tenants/%s/groups/%d", this.tenantId, this.groupKey);
        this.httpClient.delete(endpoint, this.httpRequestConfig.build(), result);
        return result;
    }
}

