/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignUserFromGroupCommandStep1;
import io.camunda.client.api.response.UnassignUserFromGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UnassignUserFromGroupCommandImpl
implements UnassignUserFromGroupCommandStep1 {
    private final long groupKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private long userKey;

    public UnassignUserFromGroupCommandImpl(long groupKey, HttpClient httpClient) {
        this.groupKey = groupKey;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignUserFromGroupCommandStep1 userKey(long userKey) {
        ArgumentUtil.ensureNotNull("userKey", userKey);
        this.userKey = userKey;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignUserFromGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignUserFromGroupResponse> send() {
        ArgumentUtil.ensureNotNull("userKey", this.userKey);
        HttpCamundaFuture<UnassignUserFromGroupResponse> result = new HttpCamundaFuture<UnassignUserFromGroupResponse>();
        this.httpClient.delete("/groups/" + this.groupKey + "/users/" + this.userKey, this.httpRequestConfig.build(), result);
        return result;
    }
}

