/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateAuthorizationCommandStep1;
import io.camunda.client.api.response.UpdateAuthorizationResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.protocol.rest.AuthorizationRequest;
import io.camunda.client.protocol.rest.OwnerTypeEnum;
import io.camunda.client.protocol.rest.PermissionTypeEnum;
import io.camunda.client.protocol.rest.ResourceTypeEnum;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateAuthorizationCommandImpl
implements UpdateAuthorizationCommandStep1,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep2,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep3,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep4,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep5,
UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep6 {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;
    private final AuthorizationRequest request;
    private final long authorizationKey;

    public UpdateAuthorizationCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, long authorizationKey) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new AuthorizationRequest();
        this.authorizationKey = authorizationKey;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep2 ownerId(String ownerId) {
        ArgumentUtil.ensureNotNullNorEmpty("ownerId", ownerId);
        this.request.setOwnerId(ownerId);
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep3 ownerType(OwnerTypeEnum ownerType) {
        ArgumentUtil.ensureNotNull("ownerType", (Object)ownerType);
        this.request.setOwnerType(ownerType);
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep4 resourceId(String resourceId) {
        ArgumentUtil.ensureNotNullNorEmpty("resourceId", resourceId);
        this.request.setResourceId(resourceId);
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep5 resourceType(ResourceTypeEnum resourceType) {
        ArgumentUtil.ensureNotNull("resourceType", (Object)resourceType);
        this.request.setResourceType(resourceType);
        return this;
    }

    @Override
    public UpdateAuthorizationCommandStep1.UpdateAuthorizationCommandStep6 permissionTypes(PermissionTypeEnum ... permissionTypes) {
        ArgumentUtil.ensureNotNull("permissionTypes", permissionTypes);
        this.request.setPermissionTypes(Arrays.asList(permissionTypes));
        return this;
    }

    @Override
    public FinalCommandStep<UpdateAuthorizationResponse> requestTimeout(Duration requestTimeout) {
        ArgumentUtil.ensurePositive("requestTimeout", requestTimeout);
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateAuthorizationResponse> send() {
        HttpCamundaFuture<UpdateAuthorizationResponse> result = new HttpCamundaFuture<UpdateAuthorizationResponse>();
        this.httpClient.put("/authorizations/" + this.authorizationKey, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }
}

