/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateGroupCommandStep1;
import io.camunda.client.api.response.UpdateGroupResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.protocol.rest.GroupChangeset;
import io.camunda.client.protocol.rest.GroupUpdateRequest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateGroupCommandImpl
implements UpdateGroupCommandStep1 {
    private final long groupKey;
    private final GroupUpdateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UpdateGroupCommandImpl(long groupKey, HttpClient httpClient, JsonMapper jsonMapper) {
        this.groupKey = groupKey;
        this.request = new GroupUpdateRequest();
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UpdateGroupCommandStep1 update(GroupChangeset groupChangeset) {
        this.request.setChangeset(groupChangeset);
        return this;
    }

    @Override
    public UpdateGroupCommandStep1 updateName(String name) {
        this.getChangesetEnsureInitialized().name(name);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateGroupResponse> send() {
        HttpCamundaFuture<UpdateGroupResponse> result = new HttpCamundaFuture<UpdateGroupResponse>();
        this.httpClient.patch("/groups/" + this.groupKey, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }

    private GroupChangeset getChangesetEnsureInitialized() {
        GroupChangeset changeset = this.request.getChangeset();
        if (changeset == null) {
            changeset = new GroupChangeset();
            this.request.setChangeset(changeset);
        }
        return changeset;
    }
}

