/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.FlowNodeInstanceGetRequest;
import io.camunda.client.api.search.response.FlowNodeInstance;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.protocol.rest.FlowNodeInstanceResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class FlowNodeInstanceGetRequestImpl
implements FlowNodeInstanceGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long flowNodeInstanceKey;

    public FlowNodeInstanceGetRequestImpl(HttpClient httpClient, long flowNodeInstanceKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.flowNodeInstanceKey = flowNodeInstanceKey;
    }

    @Override
    public FinalCommandStep<FlowNodeInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<FlowNodeInstance> send() {
        HttpCamundaFuture<FlowNodeInstance> result = new HttpCamundaFuture<FlowNodeInstance>();
        this.httpClient.get(String.format("/flownode-instances/%d", this.flowNodeInstanceKey), this.httpRequestConfig.build(), FlowNodeInstanceResult.class, SearchResponseMapper::toFlowNodeInstanceGetResponse, result);
        return result;
    }
}

