/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.ProcessDefinitionGetRequest;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.protocol.rest.ProcessDefinitionResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessDefinitionGetRequestImpl
implements ProcessDefinitionGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long processDefinitionKey;

    public ProcessDefinitionGetRequestImpl(HttpClient httpClient, long processDefinitionKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public FinalCommandStep<ProcessDefinition> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<ProcessDefinition> send() {
        HttpCamundaFuture<ProcessDefinition> result = new HttpCamundaFuture<ProcessDefinition>();
        this.httpClient.get(String.format("/process-definitions/%d", this.processDefinitionKey), this.httpRequestConfig.build(), ProcessDefinitionResult.class, SearchResponseMapper::toProcessDefinitionGetResponse, result);
        return result;
    }
}

