/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.response.DecisionDefinition;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.DecisionRequirements;
import io.camunda.client.api.search.response.FlowNodeInstance;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.response.SearchResponsePage;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.client.api.search.response.Variable;
import io.camunda.client.impl.search.response.DecisionDefinitionImpl;
import io.camunda.client.impl.search.response.DecisionInstanceImpl;
import io.camunda.client.impl.search.response.DecisionRequirementsImpl;
import io.camunda.client.impl.search.response.FlowNodeInstanceImpl;
import io.camunda.client.impl.search.response.IncidentImpl;
import io.camunda.client.impl.search.response.ProcessDefinitionImpl;
import io.camunda.client.impl.search.response.ProcessInstanceImpl;
import io.camunda.client.impl.search.response.SearchQueryResponseImpl;
import io.camunda.client.impl.search.response.SearchResponsePageImpl;
import io.camunda.client.impl.search.response.UserTaskImpl;
import io.camunda.client.impl.search.response.VariableImpl;
import io.camunda.client.protocol.rest.DecisionDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.DecisionInstanceResult;
import io.camunda.client.protocol.rest.DecisionInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.DecisionRequirementsSearchQueryResult;
import io.camunda.client.protocol.rest.FlowNodeInstanceResult;
import io.camunda.client.protocol.rest.FlowNodeInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.IncidentResult;
import io.camunda.client.protocol.rest.IncidentSearchQueryResult;
import io.camunda.client.protocol.rest.ProcessDefinitionResult;
import io.camunda.client.protocol.rest.ProcessDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.ProcessInstanceResult;
import io.camunda.client.protocol.rest.ProcessInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageResponse;
import io.camunda.client.protocol.rest.UserTaskSearchQueryResult;
import io.camunda.client.protocol.rest.VariableSearchQueryResult;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SearchResponseMapper {
    private SearchResponseMapper() {
    }

    public static SearchQueryResponse<ProcessDefinition> toProcessDefinitionSearchResponse(ProcessDefinitionSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<ProcessDefinition> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), ProcessDefinitionImpl::new);
        return new SearchQueryResponseImpl<ProcessDefinition>(instances, page);
    }

    public static ProcessDefinition toProcessDefinitionGetResponse(ProcessDefinitionResult response) {
        return new ProcessDefinitionImpl(response);
    }

    public static ProcessInstance toProcessInstanceGetResponse(ProcessInstanceResult response) {
        return new ProcessInstanceImpl(response);
    }

    public static SearchQueryResponse<ProcessInstance> toProcessInstanceSearchResponse(ProcessInstanceSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<ProcessInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), ProcessInstanceImpl::new);
        return new SearchQueryResponseImpl<ProcessInstance>(instances, page);
    }

    public static SearchQueryResponse<UserTask> toUserTaskSearchResponse(UserTaskSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<UserTask> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), UserTaskImpl::new);
        return new SearchQueryResponseImpl<UserTask>(instances, page);
    }

    public static SearchQueryResponse<Variable> toVariableSearchResponse(VariableSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Variable> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), VariableImpl::new);
        return new SearchQueryResponseImpl<Variable>(instances, page);
    }

    public static SearchQueryResponse<DecisionDefinition> toDecisionDefinitionSearchResponse(DecisionDefinitionSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionDefinition> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), DecisionDefinitionImpl::new);
        return new SearchQueryResponseImpl<DecisionDefinition>(instances, page);
    }

    public static SearchQueryResponse<FlowNodeInstance> toFlowNodeInstanceSearchResponse(FlowNodeInstanceSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<FlowNodeInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), FlowNodeInstanceImpl::new);
        return new SearchQueryResponseImpl<FlowNodeInstance>(instances, page);
    }

    public static FlowNodeInstance toFlowNodeInstanceGetResponse(FlowNodeInstanceResult response) {
        return new FlowNodeInstanceImpl(response);
    }

    public static SearchQueryResponse<Incident> toIncidentSearchResponse(IncidentSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Incident> incidents = SearchResponseMapper.toSearchResponseInstances(response.getItems(), IncidentImpl::new);
        return new SearchQueryResponseImpl<Incident>(incidents, page);
    }

    public static Incident toIncidentGetResponse(IncidentResult response) {
        return new IncidentImpl(response);
    }

    private static SearchResponsePage toSearchResponsePage(SearchQueryPageResponse pageResponse) {
        return new SearchResponsePageImpl(pageResponse.getTotalItems(), pageResponse.getFirstSortValues(), pageResponse.getLastSortValues());
    }

    public static SearchQueryResponse<DecisionRequirements> toDecisionRequirementsSearchResponse(DecisionRequirementsSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionRequirements> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), DecisionRequirementsImpl::new);
        return new SearchQueryResponseImpl<DecisionRequirements>(instances, page);
    }

    public static SearchQueryResponse<DecisionInstance> toDecisionInstanceSearchResponse(DecisionInstanceSearchQueryResult response, JsonMapper jsonMapper) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), item -> new DecisionInstanceImpl((DecisionInstanceResult)item, jsonMapper));
        return new SearchQueryResponseImpl<DecisionInstance>(instances, page);
    }

    private static <T, R> List<R> toSearchResponseInstances(List<T> items, Function<T, R> mapper) {
        return Optional.ofNullable(items).map(i -> i.stream().map(mapper).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

