/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.filter.AdHocSubprocessActivityFilter;
import io.camunda.client.api.search.query.AdHocSubprocessActivityQuery;
import io.camunda.client.api.search.response.AdHocSubprocessActivityResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.AdHocSubprocessActivityResponseImpl;
import io.camunda.client.protocol.rest.AdHocSubprocessActivitySearchQuery;
import io.camunda.client.protocol.rest.AdHocSubprocessActivitySearchQueryResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class AdHocSubprocessActivityQueryImpl
implements AdHocSubprocessActivityQuery {
    private final AdHocSubprocessActivitySearchQuery request = new AdHocSubprocessActivitySearchQuery();
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public AdHocSubprocessActivityQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AdHocSubprocessActivityQuery filter(AdHocSubprocessActivityFilter filter) {
        this.request.setFilter(filter.getRequestFilter());
        return this;
    }

    @Override
    public AdHocSubprocessActivityQuery filter(Consumer<AdHocSubprocessActivityFilter> fn) {
        return this.filter(SearchRequestBuilders.adHocSubprocessActivityFilter(fn));
    }

    @Override
    public FinalCommandStep<AdHocSubprocessActivityResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AdHocSubprocessActivityResponse> send() {
        HttpCamundaFuture<AdHocSubprocessActivityResponse> result = new HttpCamundaFuture<AdHocSubprocessActivityResponse>();
        this.httpClient.post("/element-instances/ad-hoc-activities/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), AdHocSubprocessActivitySearchQueryResult.class, AdHocSubprocessActivityResponseImpl::new, result);
        return result;
    }
}

