/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.filter.DecisionDefinitionFilter;
import io.camunda.client.api.search.query.DecisionDefinitionQuery;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.response.DecisionDefinition;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.sort.DecisionDefinitionSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.DecisionDefinitionSearchQuery;
import io.camunda.client.protocol.rest.DecisionDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionDefinitionQueryImpl
extends TypedSearchRequestPropertyProvider<DecisionDefinitionSearchQuery>
implements DecisionDefinitionQuery {
    private final DecisionDefinitionSearchQuery request = new DecisionDefinitionSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionDefinitionQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public DecisionDefinitionQuery filter(DecisionDefinitionFilter value) {
        io.camunda.client.protocol.rest.DecisionDefinitionFilter filter = (io.camunda.client.protocol.rest.DecisionDefinitionFilter)DecisionDefinitionQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public DecisionDefinitionQuery filter(Consumer<DecisionDefinitionFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionDefinitionFilter(fn));
    }

    @Override
    public DecisionDefinitionQuery sort(DecisionDefinitionSort value) {
        List sorting = (List)DecisionDefinitionQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(SearchQuerySortRequestMapper.toDecisionDefinitionSearchQuerySortRequest(sorting));
        return this;
    }

    @Override
    public DecisionDefinitionQuery sort(Consumer<DecisionDefinitionSort> fn) {
        return this.sort(SearchRequestBuilders.decisionDefinitionSort(fn));
    }

    @Override
    public DecisionDefinitionQuery page(SearchRequestPage value) {
        SearchQueryPageRequest page = (SearchQueryPageRequest)DecisionDefinitionQueryImpl.provideSearchRequestProperty(value);
        this.request.setPage(page);
        return this;
    }

    @Override
    public DecisionDefinitionQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionDefinitionSearchQuery getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchQueryStep<DecisionDefinition> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchQueryResponse<DecisionDefinition>> send() {
        HttpCamundaFuture<SearchQueryResponse<DecisionDefinition>> result = new HttpCamundaFuture<SearchQueryResponse<DecisionDefinition>>();
        this.httpClient.post("/decision-definitions/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionDefinitionSearchQueryResult.class, SearchResponseMapper::toDecisionDefinitionSearchResponse, result);
        return result;
    }
}

