/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.query.DecisionInstanceQuery;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.sort.DecisionInstanceSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.DecisionInstanceFilter;
import io.camunda.client.protocol.rest.DecisionInstanceSearchQuery;
import io.camunda.client.protocol.rest.DecisionInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionInstanceQueryImpl
extends TypedSearchRequestPropertyProvider<DecisionInstanceSearchQuery>
implements DecisionInstanceQuery {
    private final DecisionInstanceSearchQuery request = new DecisionInstanceSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionInstanceQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public DecisionInstanceQuery filter(io.camunda.client.api.search.filter.DecisionInstanceFilter value) {
        DecisionInstanceFilter filter = (DecisionInstanceFilter)DecisionInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public DecisionInstanceQuery filter(Consumer<io.camunda.client.api.search.filter.DecisionInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionInstanceFilter(fn));
    }

    @Override
    public DecisionInstanceQuery sort(DecisionInstanceSort value) {
        List sorting = (List)DecisionInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(SearchQuerySortRequestMapper.toDecisionInstanceSearchQuerySortRequest(sorting));
        return this;
    }

    @Override
    public DecisionInstanceQuery sort(Consumer<DecisionInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.decisionInstanceSort(fn));
    }

    @Override
    public DecisionInstanceQuery page(SearchRequestPage value) {
        SearchQueryPageRequest page = (SearchQueryPageRequest)DecisionInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setPage(page);
        return this;
    }

    @Override
    public DecisionInstanceQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionInstanceSearchQuery getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchQueryStep<DecisionInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchQueryResponse<DecisionInstance>> send() {
        HttpCamundaFuture<SearchQueryResponse<DecisionInstance>> result = new HttpCamundaFuture<SearchQueryResponse<DecisionInstance>>();
        this.httpClient.post("/decision-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionInstanceSearchQueryResult.class, resp -> SearchResponseMapper.toDecisionInstanceSearchResponse(resp, this.jsonMapper), result);
        return result;
    }
}

