/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.query.DecisionRequirementsQuery;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.response.DecisionRequirements;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.sort.DecisionRequirementsSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequest;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchRequestPageImpl;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.sort.DecisionRequirementsSortImpl;
import io.camunda.client.protocol.rest.DecisionRequirementsFilter;
import io.camunda.client.protocol.rest.DecisionRequirementsSearchQuery;
import io.camunda.client.protocol.rest.DecisionRequirementsSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionRequirementsQueryImpl
extends TypedSearchRequestPropertyProvider<DecisionRequirementsSearchQuery>
implements DecisionRequirementsQuery {
    private final DecisionRequirementsSearchQuery request = new DecisionRequirementsSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionRequirementsQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<DecisionRequirements> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpCamundaFuture<SearchQueryResponse<DecisionRequirements>> send() {
        HttpCamundaFuture<SearchQueryResponse<DecisionRequirements>> result = new HttpCamundaFuture<SearchQueryResponse<DecisionRequirements>>();
        this.httpClient.post("/decision-requirements/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionRequirementsSearchQueryResult.class, SearchResponseMapper::toDecisionRequirementsSearchResponse, result);
        return result;
    }

    @Override
    public DecisionRequirementsQuery filter(io.camunda.client.api.search.filter.DecisionRequirementsFilter value) {
        DecisionRequirementsFilter filter = (DecisionRequirementsFilter)DecisionRequirementsQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public DecisionRequirementsQuery filter(Consumer<io.camunda.client.api.search.filter.DecisionRequirementsFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionRequirementsFilter(fn));
    }

    @Override
    public DecisionRequirementsQuery sort(DecisionRequirementsSort value) {
        DecisionRequirementsSortImpl sorting = (DecisionRequirementsSortImpl)value;
        this.request.setSort(SearchQuerySortRequestMapper.toDecisionRequirementsSearchQuerySortRequest((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty()));
        return this;
    }

    @Override
    public DecisionRequirementsQuery sort(Consumer<DecisionRequirementsSort> fn) {
        return this.sort(SearchRequestBuilders.decisionRequirementsSort(fn));
    }

    @Override
    public DecisionRequirementsQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public DecisionRequirementsQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionRequirementsSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

