/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.filter.FlownodeInstanceFilter;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.query.FlownodeInstanceQuery;
import io.camunda.client.api.search.response.FlowNodeInstance;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.sort.FlownodeInstanceSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequest;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchRequestPageImpl;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.sort.FlownodeInstanceSortImpl;
import io.camunda.client.protocol.rest.FlowNodeInstanceFilter;
import io.camunda.client.protocol.rest.FlowNodeInstanceSearchQuery;
import io.camunda.client.protocol.rest.FlowNodeInstanceSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class FlowNodeInstanceQueryImpl
extends TypedSearchRequestPropertyProvider<FlowNodeInstanceSearchQuery>
implements FlownodeInstanceQuery {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final FlowNodeInstanceSearchQuery request = new FlowNodeInstanceSearchQuery();
    private final RequestConfig.Builder httpRequestConfig;

    public FlowNodeInstanceQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<FlowNodeInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchQueryResponse<FlowNodeInstance>> send() {
        HttpCamundaFuture<SearchQueryResponse<FlowNodeInstance>> result = new HttpCamundaFuture<SearchQueryResponse<FlowNodeInstance>>();
        this.httpClient.post("/flownode-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), FlowNodeInstanceSearchQueryResult.class, SearchResponseMapper::toFlowNodeInstanceSearchResponse, result);
        return result;
    }

    @Override
    public FlownodeInstanceQuery filter(FlownodeInstanceFilter value) {
        FlowNodeInstanceFilter filter = (FlowNodeInstanceFilter)FlowNodeInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public FlownodeInstanceQuery filter(Consumer<FlownodeInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.flowNodeInstanceFilter(fn));
    }

    @Override
    public FlownodeInstanceQuery sort(FlownodeInstanceSort value) {
        FlownodeInstanceSortImpl sorting = (FlownodeInstanceSortImpl)value;
        this.request.setSort(SearchQuerySortRequestMapper.toFlowNodeInstanceSearchQuerySortRequest((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty()));
        return this;
    }

    @Override
    public FlownodeInstanceQuery sort(Consumer<FlownodeInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.flowNodeInstanceSort(fn));
    }

    @Override
    public FlownodeInstanceQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public FlownodeInstanceQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected FlowNodeInstanceSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

