/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.query.IncidentQuery;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.sort.IncidentSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchRequestPageImpl;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.IncidentFilter;
import io.camunda.client.protocol.rest.IncidentSearchQuery;
import io.camunda.client.protocol.rest.IncidentSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class IncidentQueryImpl
extends TypedSearchRequestPropertyProvider<IncidentSearchQuery>
implements IncidentQuery {
    private final IncidentSearchQuery request = new IncidentSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public IncidentQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<Incident> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchQueryResponse<Incident>> send() {
        HttpCamundaFuture<SearchQueryResponse<Incident>> result = new HttpCamundaFuture<SearchQueryResponse<Incident>>();
        this.httpClient.post("/incidents/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), IncidentSearchQueryResult.class, SearchResponseMapper::toIncidentSearchResponse, result);
        return result;
    }

    @Override
    public IncidentQuery filter(io.camunda.client.api.search.filter.IncidentFilter value) {
        IncidentFilter filter = (IncidentFilter)IncidentQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public IncidentQuery filter(Consumer<io.camunda.client.api.search.filter.IncidentFilter> fn) {
        return this.filter(SearchRequestBuilders.incidentFilter(fn));
    }

    @Override
    public IncidentQuery sort(IncidentSort value) {
        List sorting = (List)IncidentQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(SearchQuerySortRequestMapper.toIncidentSearchQuerySortRequest(sorting));
        return this;
    }

    @Override
    public IncidentQuery sort(Consumer<IncidentSort> fn) {
        return this.sort(SearchRequestBuilders.incidentSort(fn));
    }

    @Override
    public IncidentQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public IncidentQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected IncidentSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

