/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.query.ProcessInstanceQuery;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.sort.ProcessInstanceSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.ProcessInstanceSearchQuery;
import io.camunda.client.protocol.rest.ProcessInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceQueryImpl
extends TypedSearchRequestPropertyProvider<ProcessInstanceSearchQuery>
implements ProcessInstanceQuery {
    private final ProcessInstanceSearchQuery request = new ProcessInstanceSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessInstanceQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<ProcessInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchQueryResponse<ProcessInstance>> send() {
        HttpCamundaFuture<SearchQueryResponse<ProcessInstance>> result = new HttpCamundaFuture<SearchQueryResponse<ProcessInstance>>();
        this.httpClient.post("/process-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ProcessInstanceSearchQueryResult.class, SearchResponseMapper::toProcessInstanceSearchResponse, result);
        return result;
    }

    @Override
    public ProcessInstanceQuery filter(ProcessInstanceFilter value) {
        io.camunda.client.protocol.rest.ProcessInstanceFilter filter = (io.camunda.client.protocol.rest.ProcessInstanceFilter)ProcessInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public ProcessInstanceQuery filter(Consumer<ProcessInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.processInstanceFilter(fn));
    }

    @Override
    public ProcessInstanceQuery sort(ProcessInstanceSort value) {
        List sorting = (List)ProcessInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(SearchQuerySortRequestMapper.toProcessInstanceSearchQuerySortRequest(sorting));
        return this;
    }

    @Override
    public ProcessInstanceQuery sort(Consumer<ProcessInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.processInstanceSort(fn));
    }

    @Override
    public ProcessInstanceQuery page(SearchRequestPage value) {
        SearchQueryPageRequest page = (SearchQueryPageRequest)ProcessInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setPage(page);
        return this;
    }

    @Override
    public ProcessInstanceQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected ProcessInstanceSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

