/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.filter.UserTaskFilter;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.query.UserTaskQuery;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.client.api.search.sort.UserTaskSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequest;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchRequestPageImpl;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.sort.UserTaskSortImpl;
import io.camunda.client.protocol.rest.UserTaskSearchQuery;
import io.camunda.client.protocol.rest.UserTaskSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UserTaskQueryImpl
extends TypedSearchRequestPropertyProvider<UserTaskSearchQuery>
implements UserTaskQuery {
    private final UserTaskSearchQuery request = new UserTaskSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UserTaskQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<UserTask> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public HttpCamundaFuture<SearchQueryResponse<UserTask>> send() {
        HttpCamundaFuture<SearchQueryResponse<UserTask>> result = new HttpCamundaFuture<SearchQueryResponse<UserTask>>();
        this.httpClient.post("/user-tasks/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UserTaskSearchQueryResult.class, SearchResponseMapper::toUserTaskSearchResponse, result);
        return result;
    }

    @Override
    public UserTaskQuery filter(UserTaskFilter value) {
        io.camunda.client.protocol.rest.UserTaskFilter filter = (io.camunda.client.protocol.rest.UserTaskFilter)UserTaskQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public UserTaskQuery filter(Consumer<UserTaskFilter> fn) {
        return this.filter(SearchRequestBuilders.userTaskFilter(fn));
    }

    @Override
    public UserTaskQuery sort(UserTaskSort value) {
        UserTaskSortImpl sorting = (UserTaskSortImpl)value;
        this.request.setSort(SearchQuerySortRequestMapper.toUserTaskSearchQuerySortRequest((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty()));
        return this;
    }

    @Override
    public UserTaskQuery sort(Consumer<UserTaskSort> fn) {
        return this.sort(SearchRequestBuilders.userTaskSort(fn));
    }

    @Override
    public UserTaskQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public UserTaskQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected UserTaskSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

