/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.query;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.SearchRequestBuilders;
import io.camunda.client.api.search.SearchRequestPage;
import io.camunda.client.api.search.filter.VariableFilter;
import io.camunda.client.api.search.query.FinalSearchQueryStep;
import io.camunda.client.api.search.query.VariableQuery;
import io.camunda.client.api.search.response.SearchQueryResponse;
import io.camunda.client.api.search.response.Variable;
import io.camunda.client.api.search.sort.VariableSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.SearchQuerySortRequest;
import io.camunda.client.impl.search.SearchQuerySortRequestMapper;
import io.camunda.client.impl.search.SearchRequestPageImpl;
import io.camunda.client.impl.search.SearchResponseMapper;
import io.camunda.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.sort.VariableSortImpl;
import io.camunda.client.protocol.rest.VariableSearchQuery;
import io.camunda.client.protocol.rest.VariableSearchQueryResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class VariableQueryImpl
extends TypedSearchRequestPropertyProvider<VariableSearchQuery>
implements VariableQuery {
    private final VariableSearchQuery request = new VariableSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public VariableQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<Variable> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchQueryResponse<Variable>> send() {
        HttpCamundaFuture<SearchQueryResponse<Variable>> result = new HttpCamundaFuture<SearchQueryResponse<Variable>>();
        this.httpClient.post("/variables/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), VariableSearchQueryResult.class, SearchResponseMapper::toVariableSearchResponse, result);
        return result;
    }

    @Override
    public VariableQuery filter(VariableFilter value) {
        io.camunda.client.protocol.rest.VariableFilter filter = (io.camunda.client.protocol.rest.VariableFilter)VariableQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public VariableQuery filter(Consumer<VariableFilter> fn) {
        return this.filter(SearchRequestBuilders.variableFilter(fn));
    }

    @Override
    public VariableQuery sort(VariableSort value) {
        VariableSortImpl sorting = (VariableSortImpl)value;
        this.request.setSort(SearchQuerySortRequestMapper.toVariableSearchQuerySortRequest((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty()));
        return this;
    }

    @Override
    public VariableQuery sort(Consumer<VariableSort> fn) {
        return this.sort(SearchRequestBuilders.variableSort(fn));
    }

    @Override
    public VariableQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public VariableQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected VariableSearchQuery getSearchRequestProperty() {
        return this.request;
    }
}

