/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.response.FlowNodeInstance;
import io.camunda.client.api.search.response.FlowNodeInstanceState;
import io.camunda.client.api.search.response.FlowNodeInstanceType;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.FlowNodeInstanceResult;
import java.util.Objects;

public final class FlowNodeInstanceImpl
implements FlowNodeInstance {
    private final Long flowNodeInstanceKey;
    private final Long processDefinitionKey;
    private final String processDefinitionId;
    private final Long processInstanceKey;
    private final String flowNodeId;
    private final String flowNodeName;
    private final String startDate;
    private final String endDate;
    private final Boolean incident;
    private final Long incidentKey;
    private final FlowNodeInstanceState state;
    private final String tenantId;
    private final FlowNodeInstanceType type;

    public FlowNodeInstanceImpl(FlowNodeInstanceResult item) {
        this.flowNodeInstanceKey = ParseUtil.parseLongOrNull(item.getFlowNodeInstanceKey());
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.flowNodeId = item.getFlowNodeId();
        this.flowNodeName = item.getFlowNodeName();
        this.startDate = item.getStartDate();
        this.endDate = item.getEndDate();
        this.incident = item.getHasIncident();
        this.incidentKey = ParseUtil.parseLongOrNull(item.getIncidentKey());
        this.state = FlowNodeInstanceState.fromProtocolState(item.getState());
        this.tenantId = item.getTenantId();
        this.type = FlowNodeInstanceType.fromProtocolType(item.getType());
    }

    @Override
    public Long getFlowNodeInstanceKey() {
        return this.flowNodeInstanceKey;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    @Override
    public String getFlowNodeName() {
        return this.flowNodeName;
    }

    @Override
    public String getStartDate() {
        return this.startDate;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public Boolean getIncident() {
        return this.incident;
    }

    @Override
    public Long getIncidentKey() {
        return this.incidentKey;
    }

    @Override
    public FlowNodeInstanceState getState() {
        return this.state;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public FlowNodeInstanceType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flowNodeInstanceKey, this.processDefinitionKey, this.processInstanceKey, this.processDefinitionId, this.flowNodeId, this.startDate, this.endDate, this.incident, this.incidentKey, this.state, this.tenantId, this.type});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeInstanceImpl that = (FlowNodeInstanceImpl)o;
        return Objects.equals(this.flowNodeInstanceKey, that.flowNodeInstanceKey) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.flowNodeId, that.flowNodeId) && Objects.equals(this.flowNodeName, that.flowNodeName) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate) && Objects.equals(this.incident, that.incident) && Objects.equals(this.incidentKey, that.incidentKey) && this.state == that.state && Objects.equals(this.tenantId, that.tenantId) && this.type == that.type;
    }
}

