/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.IncidentErrorType;
import io.camunda.client.api.search.response.IncidentState;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.IncidentResult;
import java.util.Objects;

public class IncidentImpl
implements Incident {
    private final Long incidentKey;
    private final Long processDefinitionKey;
    private final String processDefinitionId;
    private final Long processInstanceKey;
    private final IncidentErrorType errorType;
    private final String errorMessage;
    private final String flowNodeId;
    private final Long flowNodeInstanceKey;
    private final String creationTime;
    private final IncidentState state;
    private final Long jobKey;
    private final String tenantId;

    public IncidentImpl(IncidentResult item) {
        this.incidentKey = ParseUtil.parseLongOrNull(item.getIncidentKey());
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.errorType = IncidentErrorType.fromProtocolErrorType(item.getErrorType());
        this.errorMessage = item.getErrorMessage();
        this.flowNodeId = item.getFlowNodeId();
        this.flowNodeInstanceKey = ParseUtil.parseLongOrNull(item.getFlowNodeInstanceKey());
        this.creationTime = item.getCreationTime();
        this.state = IncidentState.fromProtocolState(item.getState());
        this.jobKey = ParseUtil.parseLongOrNull(item.getJobKey());
        this.tenantId = item.getTenantId();
    }

    @Override
    public Long getIncidentKey() {
        return this.incidentKey;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public IncidentErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    @Override
    public Long getFlowNodeInstanceKey() {
        return this.flowNodeInstanceKey;
    }

    @Override
    public String getCreationTime() {
        return this.creationTime;
    }

    @Override
    public IncidentState getState() {
        return this.state;
    }

    @Override
    public Long getJobKey() {
        return this.jobKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.incidentKey, this.processDefinitionKey, this.processDefinitionId, this.processInstanceKey, this.errorType, this.errorMessage, this.flowNodeId, this.flowNodeInstanceKey, this.creationTime, this.state, this.jobKey, this.tenantId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentImpl incident = (IncidentImpl)o;
        return Objects.equals(this.incidentKey, incident.incidentKey) && Objects.equals(this.processDefinitionKey, incident.processDefinitionKey) && Objects.equals(this.processDefinitionId, incident.processDefinitionId) && Objects.equals(this.processInstanceKey, incident.processInstanceKey) && this.errorType == incident.errorType && Objects.equals(this.errorMessage, incident.errorMessage) && Objects.equals(this.flowNodeId, incident.flowNodeId) && Objects.equals(this.flowNodeInstanceKey, incident.flowNodeInstanceKey) && Objects.equals(this.creationTime, incident.creationTime) && this.state == incident.state && Objects.equals(this.jobKey, incident.jobKey) && Objects.equals(this.tenantId, incident.tenantId);
    }
}

