/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.SortOrderEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"field", "order"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceSearchQuerySortRequest {
    public static final String JSON_PROPERTY_FIELD = "field";
    @Nonnull
    private FieldEnum field;
    public static final String JSON_PROPERTY_ORDER = "order";
    @Nullable
    private SortOrderEnum order = SortOrderEnum.ASC;

    public ProcessInstanceSearchQuerySortRequest field(@Nonnull FieldEnum field) {
        this.field = field;
        return this;
    }

    @Nonnull
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FieldEnum getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setField(@Nonnull FieldEnum field) {
        this.field = field;
    }

    public ProcessInstanceSearchQuerySortRequest order(@Nullable SortOrderEnum order) {
        this.order = order;
        return this;
    }

    @Nullable
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SortOrderEnum getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(@Nullable SortOrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceSearchQuerySortRequest processInstanceSearchQuerySortRequest = (ProcessInstanceSearchQuerySortRequest)o;
        return Objects.equals((Object)this.field, (Object)processInstanceSearchQuerySortRequest.field) && Objects.equals((Object)this.order, (Object)processInstanceSearchQuerySortRequest.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceSearchQuerySortRequest {\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getField() != null) {
            try {
                joiner.add(String.format("%sfield%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getField()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOrder() != null) {
            try {
                joiner.add(String.format("%sorder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOrder()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum FieldEnum {
        PROCESS_INSTANCE_KEY(String.valueOf("processInstanceKey")),
        PROCESS_DEFINITION_ID(String.valueOf("processDefinitionId")),
        PROCESS_DEFINITION_NAME(String.valueOf("processDefinitionName")),
        PROCESS_DEFINITION_VERSION(String.valueOf("processDefinitionVersion")),
        PROCESS_DEFINITION_VERSION_TAG(String.valueOf("processDefinitionVersionTag")),
        PROCESS_DEFINITION_KEY(String.valueOf("processDefinitionKey")),
        PARENT_PROCESS_INSTANCE_KEY(String.valueOf("parentProcessInstanceKey")),
        PARENT_FLOW_NODE_INSTANCE_KEY(String.valueOf("parentFlowNodeInstanceKey")),
        START_DATE(String.valueOf("startDate")),
        END_DATE(String.valueOf("endDate")),
        STATE(String.valueOf("state")),
        HAS_INCIDENT(String.valueOf("hasIncident")),
        TENANT_ID(String.valueOf("tenantId")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FieldEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FieldEnum fromValue(String value) {
            for (FieldEnum b : FieldEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

