/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.protocol.rest.JobCompletionRequest;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.CompleteJobResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.CompleteJobResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CompleteJobCommandImpl
extends CommandWithVariables<CompleteJobCommandStep1>
implements CompleteJobCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CompleteJobRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JobCompletionRequest httpRequestObject;
    private boolean useRest;
    private final long jobKey;
    private final JsonMapper jsonMapper;

    public CompleteJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.CompleteJobRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(key);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobCompletionRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = key;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public FinalCommandStep<CompleteJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<CompleteJobResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    @Override
    public CompleteJobCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public CompleteJobCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    private ZeebeFuture<CompleteJobResponse> sendRestRequest() {
        HttpZeebeFuture<CompleteJobResponse> result = new HttpZeebeFuture<CompleteJobResponse>();
        this.httpClient.post("/jobs/" + this.jobKey + "/completion", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private ZeebeFuture<CompleteJobResponse> sendGrpcRequest() {
        GatewayOuterClass.CompleteJobRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse> future = new RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse>(CompleteJobResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).completeJob(request, streamObserver);
    }

    @Override
    protected CompleteJobCommandStep1 setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.jsonMapper.fromJsonAsMap(variables));
        }
        return this;
    }
}

