/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.DocumentCreationBatchResponse;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateDocumentBatchCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DocumentReferenceBatchResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.DocumentReferenceBatchResponseImpl;
import io.camunda.zeebe.client.impl.util.DocumentBuilder;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.entity.mime.MultipartPartBuilder;
import org.apache.hc.core5.http.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDocumentBatchCommandImpl
implements CreateDocumentBatchCommandStep1 {
    public static final String METADATA_PART_HEADER = "X-Document-Metadata";
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDocumentBatchCommandImpl.class);
    private final List<DocumentBuilder> documents = new ArrayList<DocumentBuilder>();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private String processDefinitionId;
    private Long processInstanceKey;

    public CreateDocumentBatchCommandImpl(JsonMapper jsonMapper, HttpClient httpClient, ZeebeClientConfiguration configuration) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public FinalCommandStep<DocumentReferenceBatchResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZeebeFuture<DocumentReferenceBatchResponse> send() {
        try {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA);
            for (DocumentBuilder document : this.documents) {
                String fileName = document.getMetadata().getFileName();
                ArgumentUtil.ensureNotNull("fileName", fileName);
                InputStreamBody body = new InputStreamBody(document.getContent(), ContentType.DEFAULT_BINARY, fileName);
                if (this.processDefinitionId != null) {
                    document.getMetadata().setProcessDefinitionId(this.processDefinitionId);
                }
                if (this.processInstanceKey != null) {
                    document.getMetadata().setProcessInstanceKey(ParseUtil.keyToString(this.processInstanceKey));
                }
                String metadataString = this.jsonMapper.toJson(document.getMetadata());
                MultipartPart part = MultipartPartBuilder.create().setBody((ContentBody)body).setHeader("Content-Disposition", "form-data; name=files; filename=\"" + fileName + "\"").setHeader(METADATA_PART_HEADER, metadataString).build();
                entityBuilder.addPart(part);
            }
            HttpZeebeFuture<DocumentReferenceBatchResponse> result = new HttpZeebeFuture<DocumentReferenceBatchResponse>();
            this.httpClient.postMultipart("/documents/batch", this.queryParams, entityBuilder, this.httpRequestConfig.build(), DocumentCreationBatchResponse.class, DocumentReferenceBatchResponseImpl::new, result);
            HttpZeebeFuture<DocumentReferenceBatchResponse> httpZeebeFuture = result;
            return httpZeebeFuture;
        }
        finally {
            this.documents.stream().map(DocumentBuilder::getContent).filter(Objects::nonNull).forEach(content -> {
                try {
                    content.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close content stream", (Throwable)e);
                }
            });
        }
    }

    @Override
    public CreateDocumentBatchCommandStep1 storeId(String storeId) {
        ArgumentUtil.ensureNotNull("storeId", storeId);
        this.queryParams.put("storeId", storeId);
        return this;
    }

    @Override
    public CreateDocumentBatchCommandStep1 processDefinitionId(String processDefinitionId) {
        ArgumentUtil.ensureNotNull("processDefinitionId", processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public CreateDocumentBatchCommandStep1 processInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    @Override
    public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 addDocument() {
        DocumentBuilderStep2BatchImpl documentBuilder = new DocumentBuilderStep2BatchImpl(this);
        this.documents.add(documentBuilder);
        return documentBuilder;
    }

    public static class DocumentBuilderStep2BatchImpl
    extends DocumentBuilder
    implements CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 {
        private final CreateDocumentBatchCommandImpl parentStep;

        public DocumentBuilderStep2BatchImpl(CreateDocumentBatchCommandImpl parentStep) {
            this.parentStep = parentStep;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 content(InputStream content) {
            super.content(content);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 content(byte[] content) {
            super.content(content);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 content(String content) {
            super.content(content);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 contentType(String contentType) {
            super.contentType(contentType);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 fileName(String name) {
            super.fileName(name);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 timeToLive(Duration timeToLive) {
            super.timeToLive(timeToLive);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 customMetadata(String key, Object value) {
            super.customMetadata(key, value);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1.CreateDocumentBatchCommandStep2 customMetadata(Map<String, Object> customMetadata) {
            super.customMetadata(customMetadata);
            return this;
        }

        @Override
        public CreateDocumentBatchCommandStep1 done() {
            return this.parentStep;
        }
    }
}

