/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.protocol.rest.MessagePublicationRequest;
import io.camunda.client.protocol.rest.MessagePublicationResult;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.PublishMessageResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class PublishMessageCommandImpl
extends CommandWithVariables<PublishMessageCommandImpl>
implements PublishMessageCommandStep1,
PublishMessageCommandStep1.PublishMessageCommandStep2,
PublishMessageCommandStep1.PublishMessageCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final GatewayOuterClass.PublishMessageRequest.Builder grpcRequestObjectBuilder;
    private Duration requestTimeout;
    private boolean useRest;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final MessagePublicationRequest httpRequestObject = new MessagePublicationRequest();

    public PublishMessageCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration configuration, JsonMapper jsonMapper, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.PublishMessageRequest.newBuilder();
        this.requestTimeout = configuration.getDefaultRequestTimeout();
        this.grpcRequestObjectBuilder.setTimeToLive(configuration.getDefaultMessageTimeToLive().toMillis());
        this.tenantId(configuration.getDefaultTenantId());
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = preferRestOverGrpc;
    }

    @Override
    protected PublishMessageCommandImpl setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.objectMapper.fromJsonAsMap(variables));
        }
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 messageId(String messageId) {
        this.grpcRequestObjectBuilder.setMessageId(messageId);
        this.httpRequestObject.setMessageId(messageId);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 timeToLive(Duration timeToLive) {
        this.grpcRequestObjectBuilder.setTimeToLive(timeToLive.toMillis());
        this.httpRequestObject.setTimeToLive(timeToLive.toMillis());
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 correlationKey(String correlationKey) {
        this.grpcRequestObjectBuilder.setCorrelationKey(correlationKey);
        this.httpRequestObject.setCorrelationKey(correlationKey);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 withoutCorrelationKey() {
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep2 messageName(String messageName) {
        this.grpcRequestObjectBuilder.setName(messageName);
        this.httpRequestObject.setName(messageName);
        return this;
    }

    @Override
    public PublishMessageCommandStep1.PublishMessageCommandStep3 tenantId(String tenantId) {
        this.grpcRequestObjectBuilder.setTenantId(tenantId);
        this.httpRequestObject.setTenantId(tenantId);
        return this;
    }

    @Override
    public FinalCommandStep<PublishMessageResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<PublishMessageResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<PublishMessageResponse> sendRestRequest() {
        HttpZeebeFuture<PublishMessageResponse> result = new HttpZeebeFuture<PublishMessageResponse>();
        this.httpClient.post("/messages/publication", this.objectMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), MessagePublicationResult.class, PublishMessageResponseImpl::new, result);
        return result;
    }

    private ZeebeFuture<PublishMessageResponse> sendGrpcRequest() {
        GatewayOuterClass.PublishMessageRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<PublishMessageResponse, GatewayOuterClass.PublishMessageResponse> future = new RetriableClientFutureImpl<PublishMessageResponse, GatewayOuterClass.PublishMessageResponse>(PublishMessageResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.PublishMessageResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.PublishMessageResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.PublishMessageRequest request, StreamObserver<GatewayOuterClass.PublishMessageResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).publishMessage(request, streamObserver);
    }

    @Override
    public PublishMessageCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public PublishMessageCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

