/*
 * Copyright © 2017 camunda services GmbH (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.BatchOperationState;
import io.camunda.client.api.search.enums.BatchOperationType;
import io.camunda.client.api.search.response.BatchOperation;
import io.camunda.client.protocol.rest.BatchOperationCreatedResult;
import io.camunda.client.protocol.rest.BatchOperationResponse;
import java.util.ArrayList;
import java.util.List;

public class BatchOperationImpl implements BatchOperation {

  private final String batchOperationId;
  private final BatchOperationType type;
  private final BatchOperationState status;
  private final String startDate;
  private final String endDate;
  private final Integer operationsTotalCount;
  private final Integer operationsFailedCount;
  private final Integer operationsCompletedCount;
  private final List<Long> keys = new ArrayList<>();

  public BatchOperationImpl(final BatchOperationCreatedResult item) {
    batchOperationId = item.getBatchOperationKey();
    type =
        item.getBatchOperationType() != null
            ? BatchOperationType.valueOf(item.getBatchOperationType().name())
            : null;
    status = null;
    startDate = null;
    endDate = null;
    operationsTotalCount = null;
    operationsFailedCount = null;
    operationsCompletedCount = null;
  }

  public BatchOperationImpl(final BatchOperationResponse item) {
    batchOperationId = item.getBatchOperationId();
    type =
        item.getBatchOperationType() != null
            ? BatchOperationType.valueOf(item.getBatchOperationType().name())
            : null;
    status = item.getState() != null ? BatchOperationState.valueOf(item.getState().name()) : null;
    startDate = item.getStartDate();
    endDate = item.getEndDate();
    operationsTotalCount = item.getOperationsTotalCount();
    operationsFailedCount = item.getOperationsFailedCount();
    operationsCompletedCount = item.getOperationsCompletedCount();
  }

  @Override
  public String getBatchOperationId() {
    return batchOperationId;
  }

  @Override
  public BatchOperationState getStatus() {
    return status;
  }

  @Override
  public BatchOperationType getType() {
    return type;
  }

  @Override
  public String getStartDate() {
    return startDate;
  }

  @Override
  public String getEndDate() {
    return endDate;
  }

  @Override
  public Integer getOperationsTotalCount() {
    return operationsTotalCount;
  }

  @Override
  public Integer getOperationsFailedCount() {
    return operationsFailedCount;
  }

  @Override
  public Integer getOperationsCompletedCount() {
    return operationsCompletedCount;
  }
}
