/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Batch operation item filter request.
 */
@JsonPropertyOrder({
  BatchOperationItemFilter.JSON_PROPERTY_BATCH_OPERATION_ID,
  BatchOperationItemFilter.JSON_PROPERTY_ITEM_KEY,
  BatchOperationItemFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  BatchOperationItemFilter.JSON_PROPERTY_STATE
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class BatchOperationItemFilter {
  public static final String JSON_PROPERTY_BATCH_OPERATION_ID = "batchOperationId";
  @javax.annotation.Nullable
  private String batchOperationId;

  public static final String JSON_PROPERTY_ITEM_KEY = "itemKey";
  @javax.annotation.Nullable
  private String itemKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  /**
   * The state of the batch operation.
   */
  public enum StateEnum {
    ACTIVE(String.valueOf("ACTIVE")),
    
    COMPLETED(String.valueOf("COMPLETED")),
    
    CANCELED(String.valueOf("CANCELED")),
    
    FAILED(String.valueOf("FAILED")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private StateEnum state;

  public BatchOperationItemFilter() {
  }

  public BatchOperationItemFilter batchOperationId(@javax.annotation.Nullable String batchOperationId) {
    
    this.batchOperationId = batchOperationId;
    return this;
  }

  /**
   * The key (or operate legacy ID) of the batch operation.
   * @return batchOperationId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBatchOperationId() {
    return batchOperationId;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationId(@javax.annotation.Nullable String batchOperationId) {
    this.batchOperationId = batchOperationId;
  }

  public BatchOperationItemFilter itemKey(@javax.annotation.Nullable String itemKey) {
    
    this.itemKey = itemKey;
    return this;
  }

  /**
   * The key of the item, e.g. a process instance key.
   * @return itemKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ITEM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getItemKey() {
    return itemKey;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemKey(@javax.annotation.Nullable String itemKey) {
    this.itemKey = itemKey;
  }

  public BatchOperationItemFilter processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key of the processed item.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public BatchOperationItemFilter state(@javax.annotation.Nullable StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * The state of the batch operation.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable StateEnum state) {
    this.state = state;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchOperationItemFilter batchOperationItemFilter = (BatchOperationItemFilter) o;
    return Objects.equals(this.batchOperationId, batchOperationItemFilter.batchOperationId) &&
        Objects.equals(this.itemKey, batchOperationItemFilter.itemKey) &&
        Objects.equals(this.processInstanceKey, batchOperationItemFilter.processInstanceKey) &&
        Objects.equals(this.state, batchOperationItemFilter.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchOperationId, itemKey, processInstanceKey, state);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchOperationItemFilter {\n");
    sb.append("    batchOperationId: ").append(toIndentedString(batchOperationId)).append("\n");
    sb.append("    itemKey: ").append(toIndentedString(itemKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `batchOperationId` to the URL query string
    if (getBatchOperationId() != null) {
      try {
        joiner.add(String.format("%sbatchOperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchOperationId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `itemKey` to the URL query string
    if (getItemKey() != null) {
      try {
        joiner.add(String.format("%sitemKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getItemKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

