/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.BatchOperationTypeEnum;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * BatchOperationResponse
 */
@JsonPropertyOrder({
  BatchOperationResponse.JSON_PROPERTY_BATCH_OPERATION_ID,
  BatchOperationResponse.JSON_PROPERTY_STATE,
  BatchOperationResponse.JSON_PROPERTY_BATCH_OPERATION_TYPE,
  BatchOperationResponse.JSON_PROPERTY_START_DATE,
  BatchOperationResponse.JSON_PROPERTY_END_DATE,
  BatchOperationResponse.JSON_PROPERTY_OPERATIONS_TOTAL_COUNT,
  BatchOperationResponse.JSON_PROPERTY_OPERATIONS_FAILED_COUNT,
  BatchOperationResponse.JSON_PROPERTY_OPERATIONS_COMPLETED_COUNT
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class BatchOperationResponse {
  public static final String JSON_PROPERTY_BATCH_OPERATION_ID = "batchOperationId";
  @javax.annotation.Nullable
  private String batchOperationId;

  /**
   * The state of the batch operation.
   */
  public enum StateEnum {
    CREATED(String.valueOf("CREATED")),
    
    ACTIVE(String.valueOf("ACTIVE")),
    
    PAUSED(String.valueOf("PAUSED")),
    
    COMPLETED(String.valueOf("COMPLETED")),
    
    COMPLETED_WITH_ERRORS(String.valueOf("COMPLETED_WITH_ERRORS")),
    
    CANCELED(String.valueOf("CANCELED")),
    
    INCOMPLETED(String.valueOf("INCOMPLETED")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private StateEnum state;

  public static final String JSON_PROPERTY_BATCH_OPERATION_TYPE = "batchOperationType";
  @javax.annotation.Nullable
  private BatchOperationTypeEnum batchOperationType;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable
  private String startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable
  private String endDate;

  public static final String JSON_PROPERTY_OPERATIONS_TOTAL_COUNT = "operationsTotalCount";
  @javax.annotation.Nullable
  private Integer operationsTotalCount;

  public static final String JSON_PROPERTY_OPERATIONS_FAILED_COUNT = "operationsFailedCount";
  @javax.annotation.Nullable
  private Integer operationsFailedCount;

  public static final String JSON_PROPERTY_OPERATIONS_COMPLETED_COUNT = "operationsCompletedCount";
  @javax.annotation.Nullable
  private Integer operationsCompletedCount;

  public BatchOperationResponse() {
  }

  public BatchOperationResponse batchOperationId(@javax.annotation.Nullable String batchOperationId) {
    
    this.batchOperationId = batchOperationId;
    return this;
  }

  /**
   * Key or (Operate Legacy ID &#x3D; UUID) of the batch operation.
   * @return batchOperationId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBatchOperationId() {
    return batchOperationId;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationId(@javax.annotation.Nullable String batchOperationId) {
    this.batchOperationId = batchOperationId;
  }

  public BatchOperationResponse state(@javax.annotation.Nullable StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * The state of the batch operation.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable StateEnum state) {
    this.state = state;
  }

  public BatchOperationResponse batchOperationType(@javax.annotation.Nullable BatchOperationTypeEnum batchOperationType) {
    
    this.batchOperationType = batchOperationType;
    return this;
  }

  /**
   * Get batchOperationType
   * @return batchOperationType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BatchOperationTypeEnum getBatchOperationType() {
    return batchOperationType;
  }


  @JsonProperty(JSON_PROPERTY_BATCH_OPERATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBatchOperationType(@javax.annotation.Nullable BatchOperationTypeEnum batchOperationType) {
    this.batchOperationType = batchOperationType;
  }

  public BatchOperationResponse startDate(@javax.annotation.Nullable String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * The start date of the batch operation.
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable String startDate) {
    this.startDate = startDate;
  }

  public BatchOperationResponse endDate(@javax.annotation.Nullable String endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * The end date of the batch operation.
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable String endDate) {
    this.endDate = endDate;
  }

  public BatchOperationResponse operationsTotalCount(@javax.annotation.Nullable Integer operationsTotalCount) {
    
    this.operationsTotalCount = operationsTotalCount;
    return this;
  }

  /**
   * The total number of items contained in this stacking process.
   * @return operationsTotalCount
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATIONS_TOTAL_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOperationsTotalCount() {
    return operationsTotalCount;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS_TOTAL_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationsTotalCount(@javax.annotation.Nullable Integer operationsTotalCount) {
    this.operationsTotalCount = operationsTotalCount;
  }

  public BatchOperationResponse operationsFailedCount(@javax.annotation.Nullable Integer operationsFailedCount) {
    
    this.operationsFailedCount = operationsFailedCount;
    return this;
  }

  /**
   * The number of items which failed during execution of the batch operation. (e.g. because they are rejected by the machine)
   * @return operationsFailedCount
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATIONS_FAILED_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOperationsFailedCount() {
    return operationsFailedCount;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS_FAILED_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationsFailedCount(@javax.annotation.Nullable Integer operationsFailedCount) {
    this.operationsFailedCount = operationsFailedCount;
  }

  public BatchOperationResponse operationsCompletedCount(@javax.annotation.Nullable Integer operationsCompletedCount) {
    
    this.operationsCompletedCount = operationsCompletedCount;
    return this;
  }

  /**
   * The number of successfully completed tasks.
   * @return operationsCompletedCount
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATIONS_COMPLETED_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOperationsCompletedCount() {
    return operationsCompletedCount;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS_COMPLETED_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationsCompletedCount(@javax.annotation.Nullable Integer operationsCompletedCount) {
    this.operationsCompletedCount = operationsCompletedCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchOperationResponse batchOperationResponse = (BatchOperationResponse) o;
    return Objects.equals(this.batchOperationId, batchOperationResponse.batchOperationId) &&
        Objects.equals(this.state, batchOperationResponse.state) &&
        Objects.equals(this.batchOperationType, batchOperationResponse.batchOperationType) &&
        Objects.equals(this.startDate, batchOperationResponse.startDate) &&
        Objects.equals(this.endDate, batchOperationResponse.endDate) &&
        Objects.equals(this.operationsTotalCount, batchOperationResponse.operationsTotalCount) &&
        Objects.equals(this.operationsFailedCount, batchOperationResponse.operationsFailedCount) &&
        Objects.equals(this.operationsCompletedCount, batchOperationResponse.operationsCompletedCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchOperationId, state, batchOperationType, startDate, endDate, operationsTotalCount, operationsFailedCount, operationsCompletedCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchOperationResponse {\n");
    sb.append("    batchOperationId: ").append(toIndentedString(batchOperationId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    batchOperationType: ").append(toIndentedString(batchOperationType)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    operationsTotalCount: ").append(toIndentedString(operationsTotalCount)).append("\n");
    sb.append("    operationsFailedCount: ").append(toIndentedString(operationsFailedCount)).append("\n");
    sb.append("    operationsCompletedCount: ").append(toIndentedString(operationsCompletedCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `batchOperationId` to the URL query string
    if (getBatchOperationId() != null) {
      try {
        joiner.add(String.format("%sbatchOperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchOperationId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `batchOperationType` to the URL query string
    if (getBatchOperationType() != null) {
      try {
        joiner.add(String.format("%sbatchOperationType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchOperationType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `operationsTotalCount` to the URL query string
    if (getOperationsTotalCount() != null) {
      try {
        joiner.add(String.format("%soperationsTotalCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOperationsTotalCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `operationsFailedCount` to the URL query string
    if (getOperationsFailedCount() != null) {
      try {
        joiner.add(String.format("%soperationsFailedCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOperationsFailedCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `operationsCompletedCount` to the URL query string
    if (getOperationsCompletedCount() != null) {
      try {
        joiner.add(String.format("%soperationsCompletedCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOperationsCompletedCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

