/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.BasicStringFilterProperty;
import io.camunda.client.protocol.rest.DateTimeFilterProperty;
import io.camunda.client.protocol.rest.DecisionDefinitionTypeEnum;
import io.camunda.client.protocol.rest.DecisionInstanceStateEnum;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Decision instance search filter.
 */
@JsonPropertyOrder({
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_INSTANCE_ID,
  DecisionInstanceFilter.JSON_PROPERTY_STATE,
  DecisionInstanceFilter.JSON_PROPERTY_EVALUATION_FAILURE,
  DecisionInstanceFilter.JSON_PROPERTY_EVALUATION_DATE,
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_DEFINITION_ID,
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_DEFINITION_VERSION,
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_DEFINITION_TYPE,
  DecisionInstanceFilter.JSON_PROPERTY_TENANT_ID,
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_INSTANCE_KEY,
  DecisionInstanceFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  DecisionInstanceFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  DecisionInstanceFilter.JSON_PROPERTY_DECISION_DEFINITION_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class DecisionInstanceFilter {
  public static final String JSON_PROPERTY_DECISION_INSTANCE_ID = "decisionInstanceId";
  @javax.annotation.Nullable
  private String decisionInstanceId;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private DecisionInstanceStateEnum state;

  public static final String JSON_PROPERTY_EVALUATION_FAILURE = "evaluationFailure";
  @javax.annotation.Nullable
  private String evaluationFailure;

  public static final String JSON_PROPERTY_EVALUATION_DATE = "evaluationDate";
  @javax.annotation.Nullable
  private DateTimeFilterProperty evaluationDate;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  @javax.annotation.Nullable
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  @javax.annotation.Nullable
  private String decisionDefinitionName;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_VERSION = "decisionDefinitionVersion";
  @javax.annotation.Nullable
  private Integer decisionDefinitionVersion;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_TYPE = "decisionDefinitionType";
  @javax.annotation.Nullable
  private DecisionDefinitionTypeEnum decisionDefinitionType;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_DECISION_INSTANCE_KEY = "decisionInstanceKey";
  @javax.annotation.Nullable
  private String decisionInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty decisionDefinitionKey;

  public DecisionInstanceFilter() {
  }

  public DecisionInstanceFilter decisionInstanceId(@javax.annotation.Nullable String decisionInstanceId) {
    
    this.decisionInstanceId = decisionInstanceId;
    return this;
  }

  /**
   * The ID of the decision instance.
   * @return decisionInstanceId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionInstanceId() {
    return decisionInstanceId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionInstanceId(@javax.annotation.Nullable String decisionInstanceId) {
    this.decisionInstanceId = decisionInstanceId;
  }

  public DecisionInstanceFilter state(@javax.annotation.Nullable DecisionInstanceStateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DecisionInstanceStateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable DecisionInstanceStateEnum state) {
    this.state = state;
  }

  public DecisionInstanceFilter evaluationFailure(@javax.annotation.Nullable String evaluationFailure) {
    
    this.evaluationFailure = evaluationFailure;
    return this;
  }

  /**
   * The evaluation failure of the decision instance.
   * @return evaluationFailure
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_FAILURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEvaluationFailure() {
    return evaluationFailure;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_FAILURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationFailure(@javax.annotation.Nullable String evaluationFailure) {
    this.evaluationFailure = evaluationFailure;
  }

  public DecisionInstanceFilter evaluationDate(@javax.annotation.Nullable DateTimeFilterProperty evaluationDate) {
    
    this.evaluationDate = evaluationDate;
    return this;
  }

  /**
   * The evaluation date of the decision instance.
   * @return evaluationDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getEvaluationDate() {
    return evaluationDate;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationDate(@javax.annotation.Nullable DateTimeFilterProperty evaluationDate) {
    this.evaluationDate = evaluationDate;
  }

  public DecisionInstanceFilter decisionDefinitionId(@javax.annotation.Nullable String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the DMN decision.
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(@javax.annotation.Nullable String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DecisionInstanceFilter decisionDefinitionName(@javax.annotation.Nullable String decisionDefinitionName) {
    
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the DMN decision.
   * @return decisionDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionName(@javax.annotation.Nullable String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public DecisionInstanceFilter decisionDefinitionVersion(@javax.annotation.Nullable Integer decisionDefinitionVersion) {
    
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision.
   * @return decisionDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionVersion(@javax.annotation.Nullable Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public DecisionInstanceFilter decisionDefinitionType(@javax.annotation.Nullable DecisionDefinitionTypeEnum decisionDefinitionType) {
    
    this.decisionDefinitionType = decisionDefinitionType;
    return this;
  }

  /**
   * Get decisionDefinitionType
   * @return decisionDefinitionType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DecisionDefinitionTypeEnum getDecisionDefinitionType() {
    return decisionDefinitionType;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionType(@javax.annotation.Nullable DecisionDefinitionTypeEnum decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
  }

  public DecisionInstanceFilter tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the decision instance.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public DecisionInstanceFilter decisionInstanceKey(@javax.annotation.Nullable String decisionInstanceKey) {
    
    this.decisionInstanceKey = decisionInstanceKey;
    return this;
  }

  /**
   * The key of the decision instance. Note that this is not the unique identifier of the entity itself; the &#x60;decisionInstanceId&#x60; serves as the primary identifier. 
   * @return decisionInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionInstanceKey() {
    return decisionInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionInstanceKey(@javax.annotation.Nullable String decisionInstanceKey) {
    this.decisionInstanceKey = decisionInstanceKey;
  }

  public DecisionInstanceFilter processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public DecisionInstanceFilter processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of the process instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public DecisionInstanceFilter decisionDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty decisionDefinitionKey) {
    
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The key of the decision.
   * @return decisionDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionInstanceFilter decisionInstanceFilter = (DecisionInstanceFilter) o;
    return Objects.equals(this.decisionInstanceId, decisionInstanceFilter.decisionInstanceId) &&
        Objects.equals(this.state, decisionInstanceFilter.state) &&
        Objects.equals(this.evaluationFailure, decisionInstanceFilter.evaluationFailure) &&
        Objects.equals(this.evaluationDate, decisionInstanceFilter.evaluationDate) &&
        Objects.equals(this.decisionDefinitionId, decisionInstanceFilter.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, decisionInstanceFilter.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, decisionInstanceFilter.decisionDefinitionVersion) &&
        Objects.equals(this.decisionDefinitionType, decisionInstanceFilter.decisionDefinitionType) &&
        Objects.equals(this.tenantId, decisionInstanceFilter.tenantId) &&
        Objects.equals(this.decisionInstanceKey, decisionInstanceFilter.decisionInstanceKey) &&
        Objects.equals(this.processDefinitionKey, decisionInstanceFilter.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, decisionInstanceFilter.processInstanceKey) &&
        Objects.equals(this.decisionDefinitionKey, decisionInstanceFilter.decisionDefinitionKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionInstanceId, state, evaluationFailure, evaluationDate, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionDefinitionType, tenantId, decisionInstanceKey, processDefinitionKey, processInstanceKey, decisionDefinitionKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionInstanceFilter {\n");
    sb.append("    decisionInstanceId: ").append(toIndentedString(decisionInstanceId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    evaluationFailure: ").append(toIndentedString(evaluationFailure)).append("\n");
    sb.append("    evaluationDate: ").append(toIndentedString(evaluationDate)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionDefinitionType: ").append(toIndentedString(decisionDefinitionType)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionInstanceKey: ").append(toIndentedString(decisionInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `decisionInstanceId` to the URL query string
    if (getDecisionInstanceId() != null) {
      try {
        joiner.add(String.format("%sdecisionInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `evaluationFailure` to the URL query string
    if (getEvaluationFailure() != null) {
      try {
        joiner.add(String.format("%sevaluationFailure%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEvaluationFailure()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `evaluationDate` to the URL query string
    if (getEvaluationDate() != null) {
      joiner.add(getEvaluationDate().toUrlQueryString(prefix + "evaluationDate" + suffix));
    }

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionName` to the URL query string
    if (getDecisionDefinitionName() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionVersion` to the URL query string
    if (getDecisionDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionType` to the URL query string
    if (getDecisionDefinitionType() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionInstanceKey` to the URL query string
    if (getDecisionInstanceKey() != null) {
      try {
        joiner.add(String.format("%sdecisionInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionKey` to the URL query string
    if (getDecisionDefinitionKey() != null) {
      joiner.add(getDecisionDefinitionKey().toUrlQueryString(prefix + "decisionDefinitionKey" + suffix));
    }

    return joiner.toString();
  }

}

