/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * FormResult
 */
@JsonPropertyOrder({
  FormResult.JSON_PROPERTY_TENANT_ID,
  FormResult.JSON_PROPERTY_FORM_ID,
  FormResult.JSON_PROPERTY_SCHEMA,
  FormResult.JSON_PROPERTY_VERSION,
  FormResult.JSON_PROPERTY_FORM_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class FormResult {
  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_FORM_ID = "formId";
  @javax.annotation.Nullable
  private String formId;

  public static final String JSON_PROPERTY_SCHEMA = "schema";
  @javax.annotation.Nullable
  private Object schema;

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nullable
  private Long version;

  public static final String JSON_PROPERTY_FORM_KEY = "formKey";
  @javax.annotation.Nullable
  private String formKey;

  public FormResult() {
  }

  public FormResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the form.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public FormResult formId(@javax.annotation.Nullable String formId) {
    
    this.formId = formId;
    return this;
  }

  /**
   * The user-provided identifier of the form.
   * @return formId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormId() {
    return formId;
  }


  @JsonProperty(JSON_PROPERTY_FORM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormId(@javax.annotation.Nullable String formId) {
    this.formId = formId;
  }

  public FormResult schema(@javax.annotation.Nullable Object schema) {
    
    this.schema = schema;
    return this;
  }

  /**
   * The form content.
   * @return schema
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getSchema() {
    return schema;
  }


  @JsonProperty(JSON_PROPERTY_SCHEMA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSchema(@javax.annotation.Nullable Object schema) {
    this.schema = schema;
  }

  public FormResult version(@javax.annotation.Nullable Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * The version of the the deployed form.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@javax.annotation.Nullable Long version) {
    this.version = version;
  }

  public FormResult formKey(@javax.annotation.Nullable String formKey) {
    
    this.formKey = formKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this form.
   * @return formKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormKey() {
    return formKey;
  }


  @JsonProperty(JSON_PROPERTY_FORM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormKey(@javax.annotation.Nullable String formKey) {
    this.formKey = formKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FormResult formResult = (FormResult) o;
    return Objects.equals(this.tenantId, formResult.tenantId) &&
        Objects.equals(this.formId, formResult.formId) &&
        Objects.equals(this.schema, formResult.schema) &&
        Objects.equals(this.version, formResult.version) &&
        Objects.equals(this.formKey, formResult.formKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, formId, schema, version, formKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FormResult {\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    formId: ").append(toIndentedString(formId)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `formId` to the URL query string
    if (getFormId() != null) {
      try {
        joiner.add(String.format("%sformId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFormId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `schema` to the URL query string
    if (getSchema() != null) {
      try {
        joiner.add(String.format("%sschema%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSchema()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `formKey` to the URL query string
    if (getFormKey() != null) {
      try {
        joiner.add(String.format("%sformKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFormKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

