/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JSON object with changed job attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * &#x60;retries&#x60; - The new amount of retries for the job; must be a positive number. * &#x60;timeout&#x60; - The duration of the new timeout in ms, starting from the current moment.  Providing any of those attributes with a null value or omitting it preserves the persisted attribute’s value.  The job cannot be completed or failed with this endpoint, use the complete job or fail job endpoints instead. 
 */
@JsonPropertyOrder({
  JobChangeset.JSON_PROPERTY_RETRIES,
  JobChangeset.JSON_PROPERTY_TIMEOUT
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class JobChangeset {
  public static final String JSON_PROPERTY_RETRIES = "retries";
  @javax.annotation.Nullable
  private Integer retries;

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  @javax.annotation.Nullable
  private Long timeout;

  public JobChangeset() {
  }

  public JobChangeset retries(@javax.annotation.Nullable Integer retries) {
    
    this.retries = retries;
    return this;
  }

  /**
   * The new amount of retries for the job; must be a positive number.
   * @return retries
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRetries() {
    return retries;
  }


  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(@javax.annotation.Nullable Integer retries) {
    this.retries = retries;
  }

  public JobChangeset timeout(@javax.annotation.Nullable Long timeout) {
    
    this.timeout = timeout;
    return this;
  }

  /**
   * The duration of the new timeout in ms, starting from the current moment.
   * @return timeout
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimeout() {
    return timeout;
  }


  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeout(@javax.annotation.Nullable Long timeout) {
    this.timeout = timeout;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobChangeset jobChangeset = (JobChangeset) o;
    return Objects.equals(this.retries, jobChangeset.retries) &&
        Objects.equals(this.timeout, jobChangeset.timeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(retries, timeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobChangeset {\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timeout` to the URL query string
    if (getTimeout() != null) {
      try {
        joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

