/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MessagePublicationRequest
 */
@JsonPropertyOrder({
  MessagePublicationRequest.JSON_PROPERTY_NAME,
  MessagePublicationRequest.JSON_PROPERTY_CORRELATION_KEY,
  MessagePublicationRequest.JSON_PROPERTY_TIME_TO_LIVE,
  MessagePublicationRequest.JSON_PROPERTY_MESSAGE_ID,
  MessagePublicationRequest.JSON_PROPERTY_VARIABLES,
  MessagePublicationRequest.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class MessagePublicationRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @javax.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_CORRELATION_KEY = "correlationKey";
  @javax.annotation.Nonnull
  private String correlationKey = "";

  public static final String JSON_PROPERTY_TIME_TO_LIVE = "timeToLive";
  @javax.annotation.Nullable
  private Long timeToLive = 0l;

  public static final String JSON_PROPERTY_MESSAGE_ID = "messageId";
  @javax.annotation.Nullable
  private String messageId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable
  private Map<String, Object> variables;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public MessagePublicationRequest() {
  }

  public MessagePublicationRequest name(@javax.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The name of the message.
   * @return name
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@javax.annotation.Nonnull String name) {
    this.name = name;
  }

  public MessagePublicationRequest correlationKey(@javax.annotation.Nonnull String correlationKey) {
    
    this.correlationKey = correlationKey;
    return this;
  }

  /**
   * The correlation key of the message.
   * @return correlationKey
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CORRELATION_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCorrelationKey() {
    return correlationKey;
  }


  @JsonProperty(JSON_PROPERTY_CORRELATION_KEY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCorrelationKey(@javax.annotation.Nonnull String correlationKey) {
    this.correlationKey = correlationKey;
  }

  public MessagePublicationRequest timeToLive(@javax.annotation.Nullable Long timeToLive) {
    
    this.timeToLive = timeToLive;
    return this;
  }

  /**
   * Timespan (in ms) to buffer the message on the broker.
   * @return timeToLive
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIME_TO_LIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimeToLive() {
    return timeToLive;
  }


  @JsonProperty(JSON_PROPERTY_TIME_TO_LIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeToLive(@javax.annotation.Nullable Long timeToLive) {
    this.timeToLive = timeToLive;
  }

  public MessagePublicationRequest messageId(@javax.annotation.Nullable String messageId) {
    
    this.messageId = messageId;
    return this;
  }

  /**
   * The unique ID of the message. Only useful to ensure only one message with the given ID will ever be published (during its lifetime). 
   * @return messageId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageId() {
    return messageId;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageId(@javax.annotation.Nullable String messageId) {
    this.messageId = messageId;
  }

  public MessagePublicationRequest variables(@javax.annotation.Nullable Map<String, Object> variables) {
    
    this.variables = variables;
    return this;
  }

  public MessagePublicationRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The message variables as JSON document.
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable Map<String, Object> variables) {
    this.variables = variables;
  }

  public MessagePublicationRequest tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant of the message sender.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessagePublicationRequest messagePublicationRequest = (MessagePublicationRequest) o;
    return Objects.equals(this.name, messagePublicationRequest.name) &&
        Objects.equals(this.correlationKey, messagePublicationRequest.correlationKey) &&
        Objects.equals(this.timeToLive, messagePublicationRequest.timeToLive) &&
        Objects.equals(this.messageId, messagePublicationRequest.messageId) &&
        Objects.equals(this.variables, messagePublicationRequest.variables) &&
        Objects.equals(this.tenantId, messagePublicationRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, correlationKey, timeToLive, messageId, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessagePublicationRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    correlationKey: ").append(toIndentedString(correlationKey)).append("\n");
    sb.append("    timeToLive: ").append(toIndentedString(timeToLive)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `correlationKey` to the URL query string
    if (getCorrelationKey() != null) {
      try {
        joiner.add(String.format("%scorrelationKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCorrelationKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timeToLive` to the URL query string
    if (getTimeToLive() != null) {
      try {
        joiner.add(String.format("%stimeToLive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimeToLive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `messageId` to the URL query string
    if (getMessageId() != null) {
      try {
        joiner.add(String.format("%smessageId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessageId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        try {
          joiner.add(String.format("%svariables%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getVariables().get(_key), URLEncoder.encode(String.valueOf(getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

