/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Instructions describing a move operation. This instruction will terminate all active elementInstance at sourceElementId and activate a new element instance for each terminated one at targetElementId.
 */
@JsonPropertyOrder({
  ProcessInstanceModificationMoveBatchOperationInstruction.JSON_PROPERTY_SOURCE_ELEMENT_ID,
  ProcessInstanceModificationMoveBatchOperationInstruction.JSON_PROPERTY_TARGET_ELEMENT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-19T12:13:21.873633643Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessInstanceModificationMoveBatchOperationInstruction {
  public static final String JSON_PROPERTY_SOURCE_ELEMENT_ID = "sourceElementId";
  @javax.annotation.Nonnull
  private String sourceElementId;

  public static final String JSON_PROPERTY_TARGET_ELEMENT_ID = "targetElementId";
  @javax.annotation.Nonnull
  private String targetElementId;

  public ProcessInstanceModificationMoveBatchOperationInstruction() {
  }

  public ProcessInstanceModificationMoveBatchOperationInstruction sourceElementId(@javax.annotation.Nonnull String sourceElementId) {
    
    this.sourceElementId = sourceElementId;
    return this;
  }

  /**
   * The ID of the element that should be terminated.
   * @return sourceElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SOURCE_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceElementId() {
    return sourceElementId;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceElementId(@javax.annotation.Nonnull String sourceElementId) {
    this.sourceElementId = sourceElementId;
  }

  public ProcessInstanceModificationMoveBatchOperationInstruction targetElementId(@javax.annotation.Nonnull String targetElementId) {
    
    this.targetElementId = targetElementId;
    return this;
  }

  /**
   * The ID of the element that should be activated.
   * @return targetElementId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TARGET_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetElementId() {
    return targetElementId;
  }


  @JsonProperty(JSON_PROPERTY_TARGET_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTargetElementId(@javax.annotation.Nonnull String targetElementId) {
    this.targetElementId = targetElementId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceModificationMoveBatchOperationInstruction processInstanceModificationMoveBatchOperationInstruction = (ProcessInstanceModificationMoveBatchOperationInstruction) o;
    return Objects.equals(this.sourceElementId, processInstanceModificationMoveBatchOperationInstruction.sourceElementId) &&
        Objects.equals(this.targetElementId, processInstanceModificationMoveBatchOperationInstruction.targetElementId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceElementId, targetElementId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceModificationMoveBatchOperationInstruction {\n");
    sb.append("    sourceElementId: ").append(toIndentedString(sourceElementId)).append("\n");
    sb.append("    targetElementId: ").append(toIndentedString(targetElementId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `sourceElementId` to the URL query string
    if (getSourceElementId() != null) {
      try {
        joiner.add(String.format("%ssourceElementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSourceElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `targetElementId` to the URL query string
    if (getTargetElementId() != null) {
      try {
        joiner.add(String.format("%stargetElementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTargetElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

