/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignUserToTenantCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignUserToTenantResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class AssignUserToTenantCommandImpl
implements AssignUserToTenantCommandStep1 {
    private final String tenantId;
    private String username;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public AssignUserToTenantCommandImpl(HttpClient httpClient, String tenantId) {
        this.httpClient = httpClient;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignUserToTenantCommandStep1 username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public FinalCommandStep<AssignUserToTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignUserToTenantResponse> send() {
        HttpCamundaFuture<AssignUserToTenantResponse> result = new HttpCamundaFuture<AssignUserToTenantResponse>();
        String endpoint = String.format("/tenants/%s/users/%s", this.tenantId, this.username);
        this.httpClient.put(endpoint, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

