/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.client.api.response.UpdateRetriesJobResponse;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateRetriesJobResponseImpl;
import io.camunda.client.protocol.rest.JobChangeset;
import io.camunda.client.protocol.rest.JobUpdateRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class JobUpdateRetriesCommandImpl
implements UpdateRetriesJobCommandStep1,
UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.UpdateJobRetriesRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private boolean useRest;
    private final JobUpdateRequest httpRequestObject;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long jobKey;
    private final JsonMapper jsonMapper;

    public JobUpdateRetriesCommandImpl(GatewayGrpc.GatewayStub asyncStub, long jobKey, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.UpdateJobRetriesRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(jobKey);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobUpdateRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = jobKey;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 retries(int retries) {
        this.grpcRequestObjectBuilder.setRetries(retries);
        this.getChangesetEnsureInitialized().setRetries(retries);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateRetriesJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateRetriesJobResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private CamundaFuture<UpdateRetriesJobResponse> sendRestRequest() {
        HttpCamundaFuture<UpdateRetriesJobResponse> result = new HttpCamundaFuture<UpdateRetriesJobResponse>();
        this.httpClient.patch("/jobs/" + this.jobKey, this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private CamundaFuture<UpdateRetriesJobResponse> sendGrpcRequest() {
        GatewayOuterClass.UpdateJobRetriesRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<UpdateRetriesJobResponse, GatewayOuterClass.UpdateJobRetriesResponse> future = new RetriableClientFutureImpl<UpdateRetriesJobResponse, GatewayOuterClass.UpdateJobRetriesResponse>(UpdateRetriesJobResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).updateJobRetries(request, streamObserver);
    }

    @Override
    public UpdateRetriesJobCommandStep1.UpdateRetriesJobCommandStep2 operationReference(long operationReference) {
        this.grpcRequestObjectBuilder.setOperationReference(operationReference);
        return this;
    }

    @Override
    public UpdateRetriesJobCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public UpdateRetriesJobCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }

    private JobChangeset getChangesetEnsureInitialized() {
        JobChangeset changeset = this.httpRequestObject.getChangeset();
        if (changeset == null) {
            changeset = new JobChangeset();
            this.httpRequestObject.setChangeset(changeset);
        }
        return changeset;
    }
}

