/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignRoleFromTenantCommandStep1;
import io.camunda.client.api.response.UnassignRoleFromTenantResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class UnassignRoleFromTenantCommandImpl
implements UnassignRoleFromTenantCommandStep1 {
    private final HttpClient httpClient;
    private final String tenantId;
    private final RequestConfig.Builder httpRequestConfig;
    private String roleId;

    public UnassignRoleFromTenantCommandImpl(HttpClient httpClient, String tenantId) {
        this.httpClient = httpClient;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignRoleFromTenantCommandStep1 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignRoleFromTenantResponse> requestTimeout(Duration timeout) {
        this.httpRequestConfig.setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignRoleFromTenantResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<UnassignRoleFromTenantResponse> result = new HttpCamundaFuture<UnassignRoleFromTenantResponse>();
        this.httpClient.delete(String.format("/tenants/%s/roles/%s", this.tenantId, this.roleId), null, this.httpRequestConfig.build(), result);
        return result;
    }
}

